<?php
/*
plugin Name: SocityCore
Description: This is socity Core plugin for socity Theme.
Version:1.0.0
Author: Themepul
Author URI:http://themepul.com/
Text Domain: socitycore
Domain Path: /languages
*/
// Exit if accessed derictly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Define
define( 'SOCIRY_ACC_PATH', plugin_dir_path( __FILE__ ) . '/');
// socity Widget 
require_once( SOCIRY_ACC_PATH . 'inc/widgets/socity-social-widget.php' );
require_once( SOCIRY_ACC_PATH . 'inc/widgets/socity-recent-post-widget.php' );
require_once( SOCIRY_ACC_PATH . 'inc/widgets/socity-info-widget.php' );
// End socity Widget 
// Dynamic CSS 
require_once( SOCIRY_ACC_PATH . 'inc/css.php' );
require_once( SOCIRY_ACC_PATH . 'inc/cicon.php' );
// Custom Post 
require_once( SOCIRY_ACC_PATH . 'socity-custom-post.php' );
// End Custom Post 
// codestar  framework
require_once( SOCIRY_ACC_PATH . 'inc/csf/cs-framework.php' );
define( 'CS_ACTIVE_FRAMEWORK',   true  ); // default true
define( 'CS_ACTIVE_METABOX',     true ); // default true
define( 'CS_ACTIVE_TAXONOMY',    false ); // default true
define( 'CS_ACTIVE_SHORTCODE',   false ); // default true
define( 'CS_ACTIVE_CUSTOMIZE',   false ); // default true
// End codestar  framework
// MetaBox with Theme Optins 
require_once( SOCIRY_ACC_PATH . 'metabox/metabox.php' );
require_once( SOCIRY_ACC_PATH . 'metabox/theme-options.php' );
// End MetaBox with Theme Optins 
// Active CSF Framework 
function socity_csf_init() {
	CSFramework_Metabox::instance( array() );
}
add_action( 'init', 'socity_csf_init' );
// End Active CSF Framework 

// Page List
function socity_slide_list(){
	$args = wp_parse_args(array(
		'post_type'		=> 'slider',
		'numberposts'	=> -1,
	));
	$posts = get_posts( $args );
	$post_options = array( esc_html__('-- Select Slider --','socitycore')=>'');
	if($posts) {
		foreach($posts as $post){
			$post_options[$post->ID  ] =  $post->post_title;
		}
	}
	return $post_options;
}
// Page List
function socity_page_list(){
	$args = wp_parse_args(array(
		'post_type'		=> 'page',
		'numberposts'	=> -1,
	));
	$posts = get_posts( $args );
	$post_options = array( esc_html__('-- Select Page --','socitycore')=>'');
	if($posts) {
		foreach($posts as $post){
			$post_options[$post->ID  ] =  $post->post_title;
		}
	}
	return $post_options;
}
// End Page List

// Custom paginations Start
if ( ! function_exists( 'socity_paginate_nav' ) ) :
	function socity_paginate_nav( $socityQuery = null ) {
		if( empty( $socityQuery ) ) :
			$socityQuery = $GLOBALS['wp_query'];
		endif;
		// Don't print empty markup if there's only one page.
		if ( $socityQuery->max_num_pages < 2 ) {
			return;
		}
		$paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
		$pagenum_link = html_entity_decode( get_pagenum_link() );
		$query_args   = array();
		$url_parts    = explode( '?', $pagenum_link );
		if ( isset( $url_parts[1] ) ) {
			wp_parse_str( $url_parts[1], $query_args );
		}
		$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
		$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';
		$format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
		$format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';
		// Set up paginated links.
		$links = paginate_links( array(
			'base'     => $pagenum_link,
			'format'   => $format,
			'total'    => $socityQuery->max_num_pages,
			'current'  => $paged,
			'add_args' => array_map( 'urlencode', $query_args ),
			'prev_text' => '<i class="fa fa-angle-left" aria-hidden="true"></i>',
			'next_text' => '<i class="fa fa-angle-right" aria-hidden="true"></i>',
			'type'      => 'array',
		) );
		if ( $links ) :
		?>
		<div class="pagination-area">
			<ul class="">
				<?php foreach ( $links as $key => $page_link ) : ?>
					<li class="<?php if ( strpos( $page_link, 'current' ) !== false ) { echo ' active'; } ?>"><?php echo str_replace('span', 'a', $page_link)?></li>
				<?php endforeach ?>
			</ul>
		</div><!-- .navigation -->
		<?php
		endif;
	}
endif; 
// Custom paginations End 
// Author Social Info 
function socity_user_contact_methot($cm){
	$cm['facebook']  = esc_html__('Facebook','socitycore');
	$cm['twitter']   = esc_html__('Twitter','socitycore');
	$cm['linkedin']  = esc_html__('Linkedin','socitycore');
	$cm['pinterest'] = esc_html__('Pinterest','socitycore');
	$cm['instagram'] = esc_html__('Instagram','socitycore');
	$cm['dribbble']  = esc_html__('Dribbble','socitycore');
	return $cm;
}
add_filter('user_contactmethods','socity_user_contact_methot');
// Admin custom script  
function socitycore_admin_enqueue_scripts($hook) {
	wp_enqueue_style( 'socitycore-admin', plugin_dir_url(__FILE__) . 'assets/socity-admin.css', array(), '1.0.0', 'all' );
	if ( isset( $_REQUEST['post'] ) || isset( $_REQUEST['post_ID'] ) ) {
	$post_id = empty( $_REQUEST['post_ID'] ) ? $_REQUEST['post'] : $_REQUEST['post_ID'];
	}
	if ( "post.php" == $hook && ! class_exists( 'Classic_Editor' ) ) {
	$post_format = get_post_format($post_id);
	wp_enqueue_script( 'socitycore-custm-admin',  plugin_dir_url(__FILE__) . 'assets/js/custom-admin.js',array('jquery'), '1.0.0',true );
	wp_localize_script("socitycore-custm-admin","post_format",array("format"=>$post_format));
	}elseif( "post-new.php" == $hook && ! class_exists( 'Classic_Editor' ) ){
	wp_enqueue_script( 'socitycore-custm-admin',  plugin_dir_url(__FILE__) . 'assets/js/custom-admin.js',array('jquery'), '1.0.0',true );
	wp_localize_script("socitycore-custm-admin","post_format",array("format"=>'none'));
	}
	if ( class_exists( 'Classic_Editor' ) ) {
		wp_enqueue_script( 'socitycore-classic-admin',  plugin_dir_url(__FILE__) . 'assets/js/cleditor-admin.js',array('jquery'), '1.0.0',true );
	}
}
add_action( 'admin_enqueue_scripts', 'socitycore_admin_enqueue_scripts' );
// End Admin custom script
function add_elementor_widget_categories( $elements_manager ) {

	$elements_manager->add_category(
		'socitycore',
		[
			'title' => __( 'socity Addons', 'socitycore' ),
			'icon' => 'fa fa-plug',
		]
	);
}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories' );
// Post Social Share 
require_once( SOCIRY_ACC_PATH . 'addons/ini.php' );
    if( ! function_exists('socity_post_share_social')){
        function socity_post_share_social(){
            global $post;
            $crunchifyURL = esc_url(get_permalink());
            $crunchifyTitle = str_replace( ' ', '%20', esc_url(get_the_title()));
            
            $twitterURL = 'https://twitter.com/intent/tweet?text='.$crunchifyTitle.'&amp;url='.$crunchifyURL.'&amp;via=Crunchify';
            $facebookURL = 'https://www.facebook.com/sharer/sharer.php?u='.$crunchifyURL;
            $googleURL = 'https://plus.google.com/share?url='.$crunchifyURL;
            $linkedinURL = 'https://www.linkedin.com/shareArticle?mini=true&url='.$crunchifyURL;
        ?>
           <a data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e('Facebook','socitycore') ?>" data-original-title="<?php esc_attr_e('Facebook','socitycore') ?>" class="socity-sfacebook" href="<?php echo esc_url($facebookURL); ?>" target="_blank"><i class="fa fa-facebook"></i></a>

           <a data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e('Twitter','socitycore') ?>" data-original-title="<?php esc_attr_e('Twitter','socitycore') ?>" class="socity-stiwtter" href="<?php echo esc_url($twitterURL); ?>" target="_blank"><i class="fa fa-twitter"></i></a>

           <a data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e('Google plus','socitycore') ?>" data-original-title="<?php esc_attr_e('Google plus','socitycore') ?>" class="socity-spin" href="<?php echo esc_url($googleURL); ?>" target="_blank"><i class="fa fa-google-plus"></i></a>

           <a data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e('Linkedin','socitycore') ?>" data-original-title="<?php esc_attr_e('Linkedin','socitycore') ?>" class="socity-slinked" href="<?php echo esc_url($linkedinURL); ?>" target="_blank"><i class="fa fa-linkedin"></i></a>
        <?php
        }
    }

 	$socity_enable_svg = cs_get_option('socity_enable_svg');
    if(!empty($socity_enable_svg == 'true')){
        function cc_mime_types($mimes) {
            $mimes['svg'] = 'image/svg+xml';
            return $mimes;
        }
        add_filter('upload_mimes', 'cc_mime_types');
    }

// Registering toolkit files
function socitycore_toolkit_files() {
    wp_enqueue_style('video', plugin_dir_url(__FILE__) .'assets/video/video.css');
    wp_enqueue_style('socitycore', plugin_dir_url(__FILE__) .'assets/socitycore.css');
    wp_enqueue_script('wow-min', plugin_dir_url(__FILE__) .'assets/js/wow-min.js', array('jquery'),'1.1.3', true);
    wp_enqueue_script('video', plugin_dir_url(__FILE__) .'assets/video/video.js', array('jquery'),'1.0', true);
}
add_action('wp_enqueue_scripts', 'socitycore_toolkit_files');