<?php 

function socity_theme_options_init(){
	$settings           = array(
	  'menu_title'      => esc_html__('Socity Options','socitycore'),
	  'menu_type'       => 'submenu',
	  'menu_parent'		=> 'themes.php',
	  'menu_slug'       => 'socity_theme_options_panel',
	  'ajax_save'       => true,
	  'show_reset_all'  => true,
	  'framework_title' => esc_html__('Welcome to socity Options Panel - by Themepul','socitycore'),
	  'menu_icon'		=> esc_attr__('fa fa-home','socitycore')
	);
	CSFramework::instance( $settings, array() );
}

add_action('init','socity_theme_options_init');


function socity_theme_options($options){

	$options[]    	= array(
	    'name'      => 'socity_genarel_setting_options',
	    'title'     => esc_html__('General','socitycore'),
	    'icon'      => esc_attr__('fa fa-cogs','socitycore'),
	    'fields'    => array(
		array(
			'id'    	=> 'socity_author_info_enable',
			'type'  	=> 'switcher',
			'title' 	=> esc_html__('Author Info','socitycore'),
			'desc'		=> esc_html__('Choose Show or Hidden Author Infor on Single page. Default Show','socitycore'),
		),
		array(
			'id'       	=> 'socity_enable_preloader',
			'type'     	=> 'switcher',
			'title'    	=> esc_html__('Enable Preloader','socitycore'),
			'desc'		=> esc_html__('Select Site Preloader. Default Enable','socitycore'),
			'default'  	=> true
		),
		array(
			'id'       	=> 'socity_enable_svg',
			'type'     	=> 'switcher',
			'default'  	=> false,
			'title'    	=> esc_html__('Enable SVG ?','socitycore'),

		),
	    )
	);
	$options[]    = array(
	    'name'      => 'socity_header_options_box',
	    'title'     => esc_html__('Header','socitycore'),
	    'icon'      => esc_attr__('fa fa-header','socitycore'),
	    'sections'	=>array(
			array(
				'name'      => 'socity_header_style_options',
				'title'     => esc_html__('Header Style','socitycore'),
				'icon'      => esc_attr__('fa fa-long-arrow-up','socitycore'),
				'fields'	=> array(
					array(
						'type'    => 'subheading',
						'content' => esc_html__('Theme Header Style','socitycore')
					),
					array(
						'id'        => 'socity_header_style_select',
						'type'      => 'image_select',
						'title'     =>esc_html__('Select Header Style','socitycore'),
						'options'   => array(
						  	'1'    	=> plugin_dir_url( __FILE__ ) .'img/header-1.jpg',
						  	'2'   	=> plugin_dir_url( __FILE__ ) .'img/header-2.jpg',
						  	'3' 		=> plugin_dir_url( __FILE__ ) .'img/header-3.jpg',
						  	'4' 		=> plugin_dir_url( __FILE__ ) .'img/header-4.jpg',
						  	'5' 		=> plugin_dir_url( __FILE__ ) .'img/header-5.jpg',
						),
						'default'	=> '1',
						'radio'     => true,
					),
				)
			),
			array(
				'name'      => 'socity_header_top_options',
				'title'     => esc_html__('Top Header','socitycore'),
				'icon'      => esc_attr__('fa fa-long-arrow-up','socitycore'),
				'fields'	=> array(
					array(
						'id'        => 'socity_header_top_enable',
						'type'      => 'switcher',
						'title'     => esc_html__('Header Top Enable','socitycore'),
						'desc'		=> esc_html__('Enable Top Header If your need.','socitycore'),
						'default'  	=> true
					),
					array(
						'type'    => 'subheading',
						'content' => esc_html__('Email Section','socitycore'),
						'dependency'  => array( 'socity_header_top_enable', '==', 'true' ),
					),
					array(
						'id'          => 'socity_header_mail_icon',
						'type'        => 'icon',
						'title'       => esc_html__('Email Icon','socitycore'),
						'default'  	  => 'fa fa-envelope-o',
						'desc'	  => esc_html__('Select Email Icon','socitycore'),
						'dependency'  => array( 'socity_header_top_enable', '==', 'true' ),
					),
					array(
						'id'          => 'socity_header_email',
						'type'        => 'text',
						'title'       => esc_html__('Email','socitycore'),
						'default'  	  => esc_attr__('info@example.com','socitycore'),
						'desc'	  => esc_html__('Add Top Header Email','socitycore'),
						'dependency'  => array( 'socity_header_top_enable', '==', 'true' ),
					),
					array(
						'type'    => 'subheading',
						'content' => esc_html__('Phone Section','socitycore'),
						'dependency'  => array( 'socity_header_top_enable', '==', 'true' ),
					),
					array(
						'id'          => 'socity_header_phone_icon',
						'type'        => 'icon',
						'title'       => esc_html__('Phone Icon','socitycore'),
						'default'  	  => 'fa fa-phone',
						'desc'	  => esc_html__('Select Phone Icon','socitycore'),
						'dependency'  => array( 'socity_header_top_enable', '==', 'true' ),
					),
					array(
						'id'          => 'socity_header_phne',
						'type'        => 'text',
						'title'       => esc_html__('Phone Number','socitycore'),
						'default'  	  => esc_attr__('32888443555','socitycore'),
						'desc'	  => esc_html__('Add Top Header Phone Number','socitycore'),
						'dependency'  => array( 'socity_header_top_enable', '==', 'true' ),
					),
					array(
						'id'          => 'socity_header_phne_text',
						'type'        => 'text',
						'title'       => esc_html__('Phone Text','socitycore'),
						'default'  	  => esc_attr__('32 (00) 888 443 555','socitycore'),
						'desc'	  => esc_html__('Add Top Header Phone Number Text','socitycore'),
						'dependency'  => array( 'socity_header_top_enable', '==', 'true' ),
					),
		    	)
			),
			// Header Logo Function
			array(
				'name'      => 'socity_header_logo_options',
				'title'     => esc_html__('Logo','socitycore'),
				'icon'      => esc_attr__('fa fa-file-picture-o','socitycore'),
				'fields'	=> array(
					array(
						'id'          => 'socity_header_logo_enable',
						'type'        => 'switcher',
						'title'       => esc_html__('Header Logo Enable','socitycore'),
						'desc'	  => esc_html__('If your Need Custom Logo Then Enable','socitycore'),
						'default'	  => false,
					),
					array(
						'id'          => 'socity_header_image_logo',
						'type'        => 'image',
						'title'       => esc_html__('Normal Logo','socitycore'),
						'desc'	  => esc_html__('Please Upload Your Image Logo','socitycore'),
						'dependency'  => array( 'socity_header_logo_enable', '==', 'true' ),
					),
				)
			), 
	    	array(
				'name'      => 'socity_header_quote_options',
				'title'     => esc_html__('Quote','socitycore'),
				'icon'      => esc_attr__('fa fa-inbox','socitycore'),
				'fields'	=> array(
					array(
						'id'        => 'socity_header_quote_enable',
						'type'      => 'switcher',
						'title'     => esc_html__('Enable Header Quote','socitycore'),
						'desc'		=> esc_html__('Enable Enable Header Quote if your need','socitycore'),
						'default'	 => true,
					),
					array(
						'id'        => 'socity_header_quote_link_option',
						'type'      => 'select',
						'default'	=> 0,
						'title'     => esc_html__('Select Options','socitycore'),
						'options'  	=> array(
							'0'	=> esc_html__('Select Page Options','socitycore'),
							'1'   => esc_html__('Extranal','socitycore'),
							'2'  	=> esc_html__('Page','socitycore'),
						),
						'desc'		=> esc_html__('Select Options Here','socitycore'),
						'dependency'  => array( 'socity_header_quote_enable', '==', 'true' ),
					),
					array(
						'id'          => 'socity_header_quote_link_text',
						'type'        => 'text',
						'title'       => esc_html__('Extranal Link','socitycore'),
						'desc'		=> esc_html__('Add Extranal Link Text Here.','socitycore'),
						'dependency'  => array( 'socity_header_quote_link_option', '==', '1' ),
					),
					array(
						'id'        => 'socity_header_quote_link_page',
						'type'      => 'select',
						'title'     => esc_html__('Page Link','socitycore'),
						'options'  	=> socity_page_list(),
						'desc'	=> esc_html__('Select Wordpress Default Page Here','socitycore'),
						'dependency'  => array( 'socity_header_quote_link_option', '==', '2' ),
					),
					
					array(
						'id'          => 'socity_header_quote_hadding',
						'type'        => 'text',
						'title'       => esc_html__('Quote Hadding','socitycore'),
						'desc'	=> esc_html__('Add Quote Hadding Here.','socitycore'),
						'default'	=> esc_html__('Request a Quote','socitycore'),
						'dependency'  => array( 'socity_header_quote_enable', '==', 'true' ),
					),
				)
	    	),
	    	
	    	// Header Logo Function
			array(
				'name'      => 'socity_header_social_options',
				'title'     => esc_html__('Social','socitycore'),
				'icon'      => esc_attr__('fa fa-share-alt','socitycore'),
				'fields'	=> array(
					array(
					  'id'              => 'socity_heaer_social_links',
					  'type'            => 'group',
					  'title'           => esc_html__('Social Links','socitycore'),
					  'button_title'    => esc_html__('Add New Social','socitycore'),
					  'accordion_title' => esc_html__('Add New Social','socitycore'),
					  'fields'          => array(
						    array(
							  'id'      => 'socity_hsocial_icon',
							  'type'    => 'icon',
							  'title'   => esc_html__('Add Icon','socitycore'),
							  'default' => 'fa fa-facebook',
							),
						    array(
							  'id'    => 'socity_hsocial_link',
							  'type'  => 'text',
							  'title' => esc_html__('Add Link','socitycore'),
							),
					  	),
					),
				)
			), 
	    )
	);

	$options[]    = array(
	    'name'      => 'socity_breadcrumb_options',
	    'title'     => esc_html__('Breadcrumb','socitycore'),
	    'icon'      => esc_attr__('fa fa-bars','socitycore'),
	    'sections'    => array(
			array(
					'name'      => 'socity_breadcrumb_image_section',
					'title'     => esc_html__('Images','socitycore'),
					'icon'      => esc_attr__('fa fa-search','socitycore'),
					'fields'	=> array(
						array(
							'id'       	=> 'socity_breadcrumb_upload_image_enable',
							'type'     	=> 'switcher',
							'title'    	=> esc_html__('Breadcrumb full width Image Enable','socitycore'),
							'default'  	=> true
						),
						array(
							'id'       => 'socity_breadcrumb_image',
							'type'     => 'image',
							'title'    => esc_html__('Upload Image','socitycore'),
							'dependency'   => array( 'socity_breadcrumb_upload_image_enable', '==', 'true' )
						),
						array(
							'id'       => 'socity_breadcrumb_bg_repeat',
							'type'     => 'select',
							'title'    => esc_html__('breadcrumb Background Repeat','socitycore'),
							'options'  => array(
								'repeat'    => esc_html__('Repeat','socitycore'),
								'repeat-x'  => esc_html__('Repeat-x','socitycore'),
								'repeat-y'  => esc_html__('Repeat-y','socitycore'),
								'no-repeat' => esc_html__('No Repeat','socitycore'),
							),
							'default'  => esc_html__('no-repeat','socitycore'),
							'dependency'   => array( 'socity_breadcrumb_upload_image_enable', '==', 'true' ),
						),
						array(
							'id'       => 'socity_breadcrumb_bg_attach',
							'type'     => 'select',
							'title'    => esc_html__('breadcrumb Background Attachment','socitycore'),
							'options'  => array(
								'scroll'   => esc_html__('Scroll','socitycore'),
								'fixed'    => esc_html__('Fixed','socitycore'),
							),
							'default'  => esc_html__('scroll','socitycore'),
							'dependency'   => array( 'socity_breadcrumb_upload_image_enable', '==', 'true' ),
						),
						array(
							'id'       => 'socity_breadcrumb_bg_position',
							'type'     => 'select',
							'title'    => esc_html__('breadcrumb Background Position','socitycore'),
							'options'  => array(
							'top'    => esc_html__('Top','socitycore'),
							'bottom' => esc_html__('Bottom','socitycore'),
							'left'   => esc_html__('Left','socitycore'),
							'right'  => esc_html__('Right','socitycore'),
							'center' => esc_html__('Center','socitycore'),
							),
							'default'  => esc_html__('center','socitycore'),
							'dependency'   => array( 'socity_breadcrumb_upload_image_enable', '==', 'true' ),
						),
						array(
							'id'       => 'socity_breadcrumb_bg_size',
							'type'     => 'select',
							'title'    => esc_html__('breadcrumb Background Size','socitycore'),
							'options'  => array(
							'auto'    => esc_html__('Auto','socitycore'),
							'cover'   => esc_html__('Cover','socitycore'),
							),
							'default'  => esc_html__('cover','socitycore'),
							'dependency'   => array( 'socity_breadcrumb_upload_image_enable', '==', 'true' ),
						),
						array(
							'id'    	=> 'socity_breadcrumb_bg_oparicty',
							'type'      => 'color_picker',
							'title' 	=> esc_html__('Background RGB Color','socitycore'),
							'rgba'      => true,
							'desc' 		=> esc_html__('Choose Background Opacity Color(if you use image then select RGB Options)','socitycore'),
							'dependency'   => array( 'socity_breadcrumb_upload_image_enable', '==', 'true' ),
						),
						array(
							'id'    	=> 'socity_breadcrumb_bg_padding',
							'type'      => 'text',
							'title' 	=> esc_html__('Box Padding','socitycore'),
							'default'	=>'150px 0',
							'dependency'   => array( 'socity_breadcrumb_upload_image_enable', '==', 'true' ),
						),
				),
			),
			array(
				'name'      => 'socity_breadcrumb_content_section',
				'title'     => esc_html__('Content','socitycore'),
				'icon'      => esc_attr__('fa fa-search','socitycore'),
				'fields'	=> array(
					array(
		          		'id'    		=> 'socity_custom_page_padding',
		          		'type'  		=> 'text',
		          		'title' 		=> esc_html__('Custom page title bar Padding.','socitycore'),
		          		'desc' 		=> esc_html__('Insert custom text for the page title bar','socitycore'),
		        	),
		        	array(
		          		'id'    	=> 'socity_page_title_alinement',
		          		'type'  	=> 'select',
		          		'title' 	=> esc_html__('Page Title Bar Text Alignment.','socitycore'),
		          		'options'  => array(
						    'left'   => esc_html__('Left','socitycore'),
						    'right'  => esc_html__('Right','socitycore'),
						    'center' => esc_html__('Center','socitycore'),
						),
					'default'  	=> esc_html__('center','socitycore'),
		          		'desc' 	=> esc_html__('Choose the title and subhead text alignment. Default currently set to Left.','socitycore'),
		        	),
		        	array(
		          		'id'    	=> 'socity_page_title_f_width',
		          		'type'  	=> 'select',
		          		'title' 	=> esc_html__('Page Title Bar Text Font Weight.','socitycore'),
		          		'options'  	=> array(
						    '300'   => esc_html__('light','socitycore'),
						    '400'   => esc_html__('normal','socitycore'),
						    '600'  	=> esc_html__('Semi Bold','socitycore'),
						    '700' 	=> esc_html__('Bold','socitycore'),
						    '900' 	=> esc_html__('black','socitycore'),
						),
					'default'	=> '600',
		          		'desc' => esc_html__('Choose the title Font Weight. Default currently Font-weight Bold.','socitycore'),
		        	),
		        	array(
		          		'id'    	=> 'socity_page_title_text_transform',
		          		'type'  	=> 'select',
		          		'title' 	=> esc_html__('Page Title Bar Text Transform.','socitycore'),
		          		'options'  	=> array(
						    'uppercase'   => esc_html__('uppercase','socitycore'),
						    'capitalize'  => esc_html__('capitalize','socitycore'),
						    'lowercase'   => esc_html__('lowercase','socitycore'),
						),
					'default'  	=> esc_attr__('capitalize','socitycore'),
		          		'desc' 	=> esc_html__('Choose the title Font Transform. Default currently uppercase.','socitycore'),
		        	),
		        	array(
		          		'id'    	=> 'socity_custom_page_title_size',
		          		'type'  	=> 'text',
		          		'title' 	=> esc_html__('Page Title Bar Text Size','socitycore'),
		          		'default'   => esc_attr__('50px','socitycore'),
		          		'desc' 	=> esc_html__('In pixels. Leave empty for default value of 40px.','socitycore'),
		        	),
		        	array(
		          		'id'    	=> 'socity_custom_page_title_color',
		          		'type'      => 'color_picker',
		          		'title' 	=> esc_html__('Page Title Bar Text Color','socitycore'),
		          		'default'	=> esc_attr__('#ffffff','socitycore'),
						'rgba'      => true,
		          		'desc' 	=> esc_html__('In pixels. Leave empty for default value of #29326f','socitycore'),
		        	),
		    	)
	    	),
	    )
	);

	$options[]    = array(
	    'name'      => 'socity_typography_options',
	    'title'     => esc_html__('typography','socitycore'),
	    'icon'      => esc_attr__('fa fa-text-height','socitycore'),
	    'fields'    => array(
	      	array(
				 'id'        => 'socity_body_fonts',
				 'type'      => 'typography',
				 'title'     => esc_html__('Body Fonts','socitycore'),
				 'default'   => array(
					'family'  => esc_html__('Open Sans','socitycore'),
					'variant' => esc_attr__('400','socitycore'),
				    	'font'    => esc_html__('google','socitycore') 
				),
			),
			array(
				'id'        => 'socity_body_fonts_variant',
				'type'      => 'checkbox',
				'title'     => esc_html__('Body Fonts variant','socitycore'),
				'options'  	=> array(
				    '400'  	=> esc_html__('400','socitycore'),
				    '400i'  => esc_html__('400i','socitycore'),
				    '400i'  => esc_html__('400i','socitycore'),
				    '500i'  => esc_html__('500i','socitycore'),
				    '600'  	=> esc_html__('600','socitycore'),
				    '700'  	=> esc_html__('700','socitycore'),
				    '700i'  => esc_html__('700i','socitycore'),
				    '800'  	=> esc_html__('800','socitycore'),
				    '800i'  => esc_html__('800i','socitycore'),
				    '900'  	=> esc_html__('900','socitycore'),
				    '900i'  => esc_html__('900i','socitycore'),
				),
				'default'  => array( '400','600','700' )
			),
			array(
				 'id'        => 'socity_haddings_fonts',
				 'type'      => 'typography',
				 'title'     => esc_html__('Hadding Fonts','socitycore'),
				 'default'   => array(
				    	'family'  => esc_html__('Poppins','socitycore'),
				    	'variant' => esc_attr__('600','socitycore'),
				    	'font'    => esc_html__('google','socitycore'),
				),
			),
			array(
				'id'        => 'socity_haddings_fonts_variant',
				'type'      => 'checkbox',
				'title'     => esc_html__('Hadding Fonts variant','socitycore'),
				'options'  	=> array(
				    '100'  	=> esc_html__('100','socitycore'),
				    '100i'  => esc_html__('100i','socitycore'),
				    '200' 	=> esc_html__('200','socitycore'),
				    '200i'  => esc_html__('200i','socitycore'),
				    '300'  	=> esc_html__('300','socitycore'),
				    '300i'  => esc_html__('300i','socitycore'),
				    '400'  	=> esc_html__('400','socitycore'),
				    '400i'  => esc_html__('400i','socitycore'),
				    '400i'  => esc_html__('400i','socitycore'),
				    '500i'  => esc_html__('500i','socitycore'),
				    '600'  	=> esc_html__('600','socitycore'),
				    '700'  	=> esc_html__('700','socitycore'),
				    '700i'  => esc_html__('700i','socitycore'),
				    '800'  	=> esc_html__('800','socitycore'),
				    '800i'  => esc_html__('800i','socitycore'),
				    '900'  	=> esc_html__('900','socitycore'),
				    '900i'  => esc_html__('900i','socitycore'),
				),
				'default'  => array( '400', '400i','600','600i','700','700i','900' )
			),
			array(
				 'id'        => 'socity_menu_fonts',
				 'type'      => 'typography',
				 'title'     => esc_html__('Header Menu Fonts','socitycore'),
				 'default'   => array(
				    	'family'  => esc_html__('Open Sans','socitycore'),
				    	'variant' => esc_attr__('500','socitycore'),
				    	'font'    => esc_html__('google','socitycore'),
				),
			),
			array(
				'id'        => 'socity_menu_fonts_variant',
				'type'      => 'checkbox',
				'title'     => esc_html__('Menu Fonts variant','socitycore'),
				'options'  	=> array(
				    '100'  	=> esc_html__('100','socitycore'),
				    '100i'  => esc_html__('100i','socitycore'),
				    '200' 	=> esc_html__('200','socitycore'),
				    '200i'  => esc_html__('200i','socitycore'),
				    '300'  	=> esc_html__('300','socitycore'),
				    '300i'  => esc_html__('300i','socitycore'),
				    '400'  	=> esc_html__('400','socitycore'),
				    '400i'  => esc_html__('400i','socitycore'),
				    '400i'  => esc_html__('400i','socitycore'),
				    '500i'  => esc_html__('500i','socitycore'),
				    '600'  	=> esc_html__('600','socitycore'),
				    '700'  	=> esc_html__('700','socitycore'),
				    '700i'  => esc_html__('700i','socitycore'),
				    '800'  	=> esc_html__('800','socitycore'),
				    '800i'  => esc_html__('800i','socitycore'),
				    '900'  	=> esc_html__('900','socitycore'),
				    '900i'  => esc_html__('900i','socitycore'),
				),
				'default'  => array( '400','500','600' )
			),
	    )
	);
	$options[]    = array(
	    'name'      => 'socity_error_options_box',
	    'title'     => esc_html__('Error','socitycore'),
	    'icon'      => esc_attr__('fa fa-bug','socitycore'),
	    'sections'	=>array(
	    	// Header Logo Function
	    		array(
				'name'      => 'socity_page_error_options',
				'title'     => esc_html__('404 Error','socitycore'),
				'icon'      => esc_attr__('fa fa-file-picture-o','socitycore'),
				'fields'	=> array(
					array(
						'id'          => 'socity_page_error_img_enable',
						'type'        => 'switcher',
						'title'       => esc_html__('Enable Image','socitycore'),
						'desc'		  => esc_html__('Enable 404 image','socitycore'),
					),
						array(
						'id'          => 'socity_page_error_img',
						'type'        => 'image',
						'title'       => esc_html__('Upload Image','socitycore'),
						'desc'		  => esc_html__('Upload 404 error image','socitycore'),
						'dependency'  => array( 'socity_page_error_img_enable', '==', 'true' ),
					),
					array(
						'id'          => 'socity_page_error_text',
						'type'        => 'text',
						'title'       => esc_html__('404 Text','socitycore'),
						'desc'		  => esc_html__('Upload 404 text','socitycore'),
						'dependency'  => array( 'socity_page_error_img_enable', '==', 'false' ),
					),
					array(
						'id'          => 'socity_page_error_small_text',
						'type'        => 'textarea',
						'title'       => esc_html__('Small Text','socitycore'),
						'default'	  => esc_html__('Oops! That page can’t be found.','socitycore'),
						'desc'		  => esc_html__('Please Type 404 small Text','socitycore'),
					),
					array(
						'id'          => 'socity_page_error_dec',
						'type'        => 'textarea',
						'title'       => esc_html__('Sort Description','socitycore'),
						'default'	  => esc_html__('It looks like nothing was found at this location. Maybe try one of the links below or a search?','socitycore'),
						'desc'		  => esc_html__('Please Type 404 Sort Description ','socitycore'),
					),
				)
			),
	    )
	);
	$options[]    	= array(
	    'name'      => 'socity_ft_options',
	    'title'     => esc_html__('Footer','socitycore'),
	    'icon'      => esc_attr__('fa fa-cogs','socitycore'),
	    'fields'    => array(
	    	array(
          		'id'    	=> 'socity_ft_top_color',
          		'type'      => 'color_picker',
          		'title' 	=> esc_html__('Footer Top area Background Color','socitycore'),
          		'default'	=> esc_attr__('#0c0d0d','socitycore'),
          		'desc' 		=> esc_html__('Choose Footer Top area Background Color','socitycore'),
        	),
        	array(
          		'id'    	=> 'socity_ft_bottom_color',
          		'type'      => 'color_picker',
          		'title' 	=> esc_html__('Footer Bottom area Background Color','socitycore'),
          		'default'	=> esc_attr__('#060606','socitycore'),
          		'desc' 		=> esc_html__('Choose Footer Bottom area Background Color','socitycore'),
        	),
        	array(
			'id'    	=> 'socity_ft_copyright',
			'type'      => 'wysiwyg',
			'title' 	=> esc_html__('Copyright','socitycore'),
			'default'	=>wp_kses(
				  __( '© 2020 <a href="#">@Themepul</a> All Rights Reserved.', 'socitycore' ),
				  array(
					  'a' => array(
					    'href' => array(),
					    'title' => array(),
					    'class' => array()
					),
				  )
			  ),
			'desc' 		=> esc_html__('Add Copyright Content','socitycore'),
	    ),
	      	
	    )
	);
	$options[]    = array(
	    'name'      => 'socity_script_options',
	    'title'     => esc_html__('Script Setting','socitycore'),
	    'icon'      => esc_attr__('fa fa-code','socitycore'),
	    'fields'    => array(
	      	array(
				'id'       	=> 'socity_head_script',
				'type'     	=> 'textarea',
				'sanitize'	=> false,
				'title'    	=> esc_html__('Head Script','socitycore'),
				'desc' 		=> esc_html__('Scripts Goes Just Before Closing </ head >','socitycore'),
			),
			array(
				'id'       	=> 'socity_body_end_script',
				'type'     	=> 'textarea',
				'sanitize'	=> false,
				'title'    	=> esc_html__('Footer Script','socitycore'),
				'desc' 		=> esc_html__('Scripts Goes Just Before </ Body >','socitycore'),
			),
	    )
	);
	$options[]    = array(
	    'name'      => 'socity_customn_css_options',
	    'title'     => esc_html__('Custom Css','socitycore'),
	    'icon'      => esc_attr__('fa fa-code','socitycore'),
	    'fields'    => array(
	      	array(
				'id'       	=> 'socity_custom_css_script',
				'type'     	=> 'textarea',
				'sanitize'	=> false,
				'title'    	=> esc_html__('Custom Css','socitycore'),
				'desc' 		=> esc_html__('Add Custom Css Here','socitycore'),
			),
	    )
	);
	$options[]    = array(
	    'name'      => 'socity_backup_options',
	    'title'     => esc_html__('BackUp','socitycore'),
	    'icon'      => esc_attr__('fa fa-sign-out','socitycore'),
	    'fields'    => array(
	      	array(
				'type'     	=> 'backup',
				'sanitize'	=> false,
				'title'    	=> esc_html__('BackUp','socitycore'),
				'desc' 		=> esc_html__('BaackUp Your Theme Options Data','socitycore'),
			),
	    )
	);
	return $options;
}

add_filter('cs_framework_options','socity_theme_options');