<?php
if ( ! function_exists( 'socity_google_font_url' ) ) :
/**
 * Register Google fonts.
 *
 * @return string Google fonts URL for the theme.
 */
function socity_google_font_url() {
  if( is_cs_framework_active() ) {
    $fonts_url = '';
    $fonts     = array();
    if( is_cs_framework_active() ) {
    $socity_body_fonts_variant = cs_get_option('socity_body_fonts_variant');
    $socity_body_fonts_variant_process = implode(',', $socity_body_fonts_variant);
    $socity_body_subsets   = ':'.esc_html($socity_body_fonts_variant_process).'';
    $socity_body_fonts = cs_get_option('socity_body_fonts')['family'];
    $socity_body_fonts .=$socity_body_subsets;
    $socity_haddings_fonts = cs_get_option('socity_haddings_fonts')['family'];
    $socity_haddings_fonts_variant = cs_get_option('socity_haddings_fonts_variant');
    $socity_haddings_fonts_variant_process = implode(',', $socity_haddings_fonts_variant);
    $socity_hadding_subsets   = ':'.esc_html($socity_haddings_fonts_variant_process).'';
    $socity_haddings_fonts .=$socity_hadding_subsets;
    $socity_menu_fonts = cs_get_option('socity_menu_fonts')['family'];
    $socity_menu_fonts_variant = cs_get_option('socity_menu_fonts_variant');
    $socity_menu_fonts_variant_process = implode(',', $socity_menu_fonts_variant);
    $socity_menu_subsets   = ':'.esc_html($socity_menu_fonts_variant_process).'';
    $socity_menu_fonts .=$socity_menu_subsets;
    }
    if ( 'off' !== esc_html_x( 'on', 'Google font: on or off', 'socitycore' ) ) {
        $fonts[] =$socity_body_fonts; 
    }
    if ( 'off' !== esc_html_x( 'on', 'Google font: on or off', 'socitycore' ) ) {
        $fonts[] = $socity_haddings_fonts;
    }
    if ( 'off' !== esc_html_x( 'on', 'Google font: on or off', 'socitycore' ) ) {
        $fonts[] = $socity_menu_fonts;
    }
    if ( $fonts ) {
        $fonts_url = add_query_arg( array(
            'family' => urlencode( implode( '|', $fonts ) ),
        ), 'https://fonts.googleapis.com/css' );
    }
    return $fonts_url;
}
}
endif;

/**
 * Enqueue scripts and styles.
 */
function socity_google_font_script() {
    wp_enqueue_style( 'socity-google-fonts', socity_google_font_url(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'socity_google_font_script' );


function socity_custom_css() {
   wp_enqueue_style(
    'socity-custom-style', get_template_directory_uri() . '/assets/css/custom-style.css', array('bootstrap','socity-theme','socitycore','socity-typrography','socity-default','sm-simple')
    );

    $socity_page_id = get_the_ID();
    if(get_post_meta($socity_page_id, 'socity_page_meta_options', true)){
          $socity_page_meta = get_post_meta($socity_page_id, 'socity_page_meta_options', true);
    }else{
          $socity_page_meta = array();
    }

 if( is_cs_framework_active() ) {
        $socity_body_fonts = cs_get_option('socity_body_fonts')['family'];
        $socity_body_fonts_variant = cs_get_option('socity_body_fonts')['variant'];
        $socity_haddings_fonts = cs_get_option('socity_haddings_fonts')['family'];
        $socity_haddings_fonts_variant = cs_get_option('socity_haddings_fonts')['variant'];
        $socity_menu_fonts = cs_get_option('socity_menu_fonts')['family'];
        $socity_menu_fonts_variant = cs_get_option('socity_menu_fonts')['variant'];
        if(array_key_exists('socity_page_header_select', $socity_page_meta)){
			$socity_page_header_select = $socity_page_meta['socity_page_header_select'];
		}
        if(array_key_exists('socity_header_top_padding', $socity_page_meta)){
			$socity_header_top_padding = $socity_page_meta['socity_header_top_padding'];
		}
        if(array_key_exists('socity_header_top_bg', $socity_page_meta)){
			$socity_header_top_bg = $socity_page_meta['socity_header_top_bg'];
		}
        if(array_key_exists('socity_main_header_bg', $socity_page_meta)){
			$socity_main_header_bg = $socity_page_meta['socity_main_header_bg'];
		}
        if(array_key_exists('socity_logo_bg_color', $socity_page_meta)){
			$socity_logo_bg_color = $socity_page_meta['socity_logo_bg_color'];
		}
        if(array_key_exists('socity_logo_bg_color5', $socity_page_meta)){
			$socity_logo_bg_color5 = $socity_page_meta['socity_logo_bg_color5'];
		}
        if(array_key_exists('socity_menu5_color', $socity_page_meta)){
			$socity_menu5_color = $socity_page_meta['socity_menu5_color'];
		}
        if(array_key_exists('socity_menu5_hcolor', $socity_page_meta)){
			$socity_menu5_hcolor = $socity_page_meta['socity_menu5_hcolor'];
		}
        if(array_key_exists('socity_logo_hedigh', $socity_page_meta)){
			$socity_logo_hedigh = $socity_page_meta['socity_logo_hedigh'];
		}
        if(array_key_exists('socity_logo_hedigh5', $socity_page_meta)){
			$socity_logo_hedigh5 = $socity_page_meta['socity_logo_hedigh5'];
		}
        if(array_key_exists('socity_logo_widght', $socity_page_meta)){
			$socity_logo_widght = $socity_page_meta['socity_logo_widght'];
		}
        if(array_key_exists('socity_logo_widght5', $socity_page_meta)){
			$socity_logo_widght5 = $socity_page_meta['socity_logo_widght5'];
		}
        $socity_ft_top_color = cs_get_option('socity_ft_top_color');
        $socity_ft_bottom_color = cs_get_option('socity_ft_bottom_color');
        $socity_breadcrumb_upload_image_enable = cs_get_option('socity_breadcrumb_upload_image_enable');
        $socity_breadcrumb_image = cs_get_option('socity_breadcrumb_image');
        $socity_breadcrumb_image_array = wp_get_attachment_image_src( $socity_breadcrumb_image, 'full', false );
        $socity_breadcrumb_bg_repeat = cs_get_option('socity_breadcrumb_bg_repeat');
        $socity_breadcrumb_bg_attach = cs_get_option('socity_breadcrumb_bg_attach');
        $socity_breadcrumb_bg_position = cs_get_option('socity_breadcrumb_bg_position');
        $socity_breadcrumb_bg_oparicty = cs_get_option('socity_breadcrumb_bg_oparicty');
        $socity_breadcrumb_bg_padding = cs_get_option('socity_breadcrumb_bg_padding');
        $socity_custom_page_padding = cs_get_option('socity_custom_page_padding');
        $socity_breadcrumb_bg_size = cs_get_option('socity_breadcrumb_bg_size');
        $socity_page_title_alinement = cs_get_option('socity_page_title_alinement');
        $socity_custom_page_title_size = cs_get_option('socity_custom_page_title_size');
        $socity_custom_page_title_color = cs_get_option('socity_custom_page_title_color');
        $socity_page_title_f_width = cs_get_option('socity_page_title_f_width');
        $socity_page_title_text_transform = cs_get_option('socity_page_title_text_transform');

        $socity_theme_color = cs_get_option('socity_theme_color');
        $socity_theme_secondary_color = cs_get_option('socity_theme_secondary_color');
        $socity_custom_css_add ='
            body,p {font-family:'.esc_html($socity_body_fonts).';font-weight:'.esc_attr($socity_body_fonts_variant).'}
            h1,h2,h3,h4,h5,h6 {font-family:'.esc_html($socity_haddings_fonts).';font-weight:'.esc_attr($socity_haddings_fonts_variant).'}
            .sm-simple a{font-family:'.esc_html($socity_menu_fonts).';font-weight:'.esc_attr($socity_menu_fonts_variant).'}
        ';
    }
    
    if( is_cs_framework_active() ) {

        if( array_key_exists('socity_page_header_select', $socity_page_meta)){
            if(!empty($socity_page_header_select == '2' )){
                $socity_custom_css_add.= '.header-area.header2 .header-main-area{background-color:'.esc_attr($socity_main_header_bg).'}';
                $socity_custom_css_add.= '.header-area.header2 .header-top{background-color:'.esc_attr($socity_header_top_bg).'}';
                $socity_custom_css_add.= '.header-area.header2 .header-top{padding:'.esc_attr($socity_header_top_padding).'}';
            }
            if(!empty($socity_page_header_select == '4' )){
                $socity_custom_css_add.= '.header-area.header4 .theme-logo a{min-height:'.esc_attr($socity_logo_hedigh).'}';
                $socity_custom_css_add.= '.header-area.header4 .theme-logo a{min-width:'.esc_attr($socity_logo_widght).'}';
                $socity_custom_css_add.= '.header-area.header4 .theme-logo a{background-color:'.esc_attr($socity_logo_bg_color).'}';
            }
            if(!empty($socity_page_header_select == '5' )){
                $socity_custom_css_add.= '.header-area.header5 .theme-logo a{min-height:'.esc_attr($socity_logo_hedigh5).'}';
                $socity_custom_css_add.= '.header-area.header5 .theme-logo a{min-width:'.esc_attr($socity_logo_widght5).'}';
                $socity_custom_css_add.= '.header-area.header5 .theme-logo a{background-color:'.esc_attr($socity_logo_bg_color5).'}';
                $socity_custom_css_add.= '.header-area.header5 #navmenu>ul>li>a,.header-area.header5 .header-quote-icon i:before,.header-area.header5 .header-quote-content h4,.header-area.header5 .header-quote-content h2{color:'.esc_attr($socity_menu5_color).'}';
                $socity_custom_css_add.= '.header-area.header5 #navmenu>ul>li>a:hover,.header-area.header5 .header-quote a:hover .header-quote-icon i:before, .header-area.header5 .header-quote a:hover h4,.header-area.header5 .header-quote a:hover h2{color:'.esc_attr($socity_menu5_hcolor).'}';
            }
        }

        if(!empty($socity_ft_bottom_color)){
            $socity_custom_css_add.= '.socity-footer-bottom{background-color:'.esc_attr($socity_ft_bottom_color).'}';
        }
        if($socity_breadcrumb_upload_image_enable == 'true' ){
            if(!empty($socity_breadcrumb_image)){
                $socity_custom_css_add.= '.breadcroumb-boxs{background-image:url('.esc_url($socity_breadcrumb_image_array[0]).')}';
            }
            if(!empty($socity_breadcrumb_bg_repeat)){
                $socity_custom_css_add.= '.breadcroumb-boxs{background-repeat:'.esc_attr($socity_breadcrumb_bg_repeat).'}';
            }
            if(!empty($socity_breadcrumb_bg_position)){
                $socity_custom_css_add.= '.breadcroumb-boxs{background-position:'.esc_attr($socity_breadcrumb_bg_position).'}';
            }
            if(!empty($socity_breadcrumb_bg_attach)){
                $socity_custom_css_add.= '.breadcroumb-boxs{background-attachment:'.esc_attr($socity_breadcrumb_bg_attach).'}';
            }
            if(!empty($socity_breadcrumb_bg_size)){
                $socity_custom_css_add.= '.breadcroumb-boxs{background-size:'.esc_attr($socity_breadcrumb_bg_size).'}';
            }
            if(!empty($socity_breadcrumb_bg_oparicty)){
                $socity_custom_css_add.= '.breadcroumb-boxs:after{background-color:'.esc_attr($socity_breadcrumb_bg_oparicty).'}';
            }
            if(!empty($socity_breadcrumb_bg_padding)){
                $socity_custom_css_add.= '.breadcroumb-boxs{padding:'.esc_attr($socity_breadcrumb_bg_padding).'}';
            }
        }
        if(!empty($socity_custom_page_padding)){
            $socity_custom_css_add.= '.brea-title h2 {padding:'.esc_attr($socity_custom_page_padding).'}';
        }
        if(!empty($socity_page_title_alinement)){
            $socity_custom_css_add.= '.brea-title h2 {text-align:'.esc_attr($socity_page_title_alinement).'}';
        }
        if(!empty($socity_custom_page_title_bg)){
            $socity_custom_css_add.= '.brea-title h2 span:after {background-color:'.esc_attr($socity_custom_page_title_bg).'}';
        }
        if(!empty($socity_custom_page_title_size)){
            $socity_custom_css_add.= '.brea-title h2 {font-size:'.esc_attr($socity_custom_page_title_size).'}';
        }
        if(!empty($socity_custom_page_title_color)){
            $socity_custom_css_add.= '.brea-title h2 {color:'.esc_attr($socity_custom_page_title_color).'}';
        }
        if(!empty($socity_page_title_f_width)){
            $socity_custom_css_add.= '.brea-title h2 {font-weight:'.esc_attr($socity_page_title_f_width).'}';
        }
        if(!empty($socity_page_title_text_transform)){
            $socity_custom_css_add.= '.brea-title h2 {text-transform:'.esc_attr($socity_page_title_text_transform).'}';
        }
        wp_add_inline_style( 'socity-custom-style', $socity_custom_css_add );
    }
}
add_action( 'wp_enqueue_scripts', 'socity_custom_css' );