<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
 *
 * Field: Background
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
class CSFramework_Option_background extends CSFramework_Options {

  public function __construct( $field, $value = '', $unique = '' ) {
    parent::__construct( $field, $value, $unique );
  }

  public function output() {

    echo $this->element_before();

    $value_defaults = array(
      'image'       => '',
      'repeat'      => '',
      'position'    => '',
      'attachment'  => '',
      'size'        => '',
      'color'       => '',
    );

    $this->value  = wp_parse_args( $this->element_value(), $value_defaults );

    if( isset( $this->field['settings'] ) ) { extract( $this->field['settings'] ); }

    $upload_type  = ( isset( $upload_type  ) ) ? $upload_type  : 'image';
    $button_title = ( isset( $button_title ) ) ? $button_title : esc_html__( 'Upload', 'cs-framework' );
    $frame_title  = ( isset( $frame_title  ) ) ? $frame_title  : esc_html__( 'Upload', 'cs-framework' );
    $insert_title = ( isset( $insert_title ) ) ? $insert_title : esc_html__( 'Use Image', 'cs-framework' );

    echo '<div class="cs-field-upload">';
    echo '<input type="text" name="'. $this->element_name( '[image]' ) .'" value="'. $this->value['image'] .'"'. $this->element_class() . $this->element_attributes() .'/>';
    echo '<a href="#" class="button cs-add" data-frame-title="'. $frame_title .'" data-upload-type="'. $upload_type .'" data-insert-title="'. $insert_title .'">'. $button_title .'</a>';
    echo '</div>';

    // background attributes
    echo '<fieldset>';
    echo cs_add_element( array(
        'pseudo'          => true,
        'type'            => 'select',
        'name'            => $this->element_name( '[repeat]' ),
        'options'         => array(
          ''              => esc_html__('repeat','cs-framework'),
          'repeat-x'      => esc_html__('repeat-x','cs-framework'),
          'repeat-y'      => esc_html__('repeat-y','cs-framework'),
          'no-repeat'     => esc_html__('no-repeat','cs-framework'),
          'inherit'       => esc_html__('inherit','cs-framework'),
        ),
        'attributes'      => array(
          'data-atts'     => 'repeat',
        ),
        'value'           => $this->value['repeat']
    ) );
    echo cs_add_element( array(
        'pseudo'          => true,
        'type'            => 'select',
        'name'            => $this->element_name( '[position]' ),
        'options'         => array(
          ''              => esc_html__('left top','cs-framework'),
          'left center'   => esc_html__('left center','cs-framework'),
          'left bottom'   => esc_html__('left bottom','cs-framework'),
          'right top'     => esc_html__('right top','cs-framework'),
          'right center'  => esc_html__('right center','cs-framework'),
          'right bottom'  => esc_html__('right bottom','cs-framework'),
          'center top'    => esc_html__('center top','cs-framework'),
          'center center' => esc_html__('center center','cs-framework'),
          'center bottom' => esc_html__('center bottom','cs-framework'),
        ),
        'attributes'      => array(
          'data-atts'     => 'position',
        ),
        'value'           => $this->value['position']
    ) );
    echo cs_add_element( array(
        'pseudo'          => true,
        'type'            => 'select',
        'name'            => $this->element_name( '[attachment]' ),
        'options'         => array(
          ''              => esc_html__('scroll','cs-framework'),
          'fixed'         => esc_html__('fixed','cs-framework'),
        ),
        'attributes'      => array(
          'data-atts'     => 'attachment',
        ),
        'value'           => $this->value['attachment']
    ) );
    echo cs_add_element( array(
        'pseudo'          => true,
        'type'            => 'select',
        'name'            => $this->element_name( '[size]' ),
        'options'         => array(
          ''              => esc_html__('size','cs-framework'),
          'cover'         => esc_html__('cover','cs-framework'),
          'contain'       => esc_html__('contain','cs-framework'),
          'inherit'       => esc_html__('inherit','cs-framework'),
          'initial'       => esc_html__('initial','cs-framework'),
        ),
        'attributes'      => array(
          'data-atts'     => 'size',
        ),
        'value'           => $this->value['size']
    ) );
    echo cs_add_element( array(
        'pseudo'          => true,
        'id'              => $this->field['id'].'_color',
        'type'            => 'color_picker',
        'name'            => $this->element_name('[color]'),
        'attributes'      => array(
          'data-atts'     => 'bgcolor',
        ),
        'value'           => $this->value['color'],
        'default'         => ( isset( $this->field['default']['color'] ) ) ? $this->field['default']['color'] : '',
        'rgba'            => ( isset( $this->field['rgba'] ) && $this->field['rgba'] === false ) ? false : '',
    ) );
    echo '</fieldset>';

    echo $this->element_after();

  }
}
