<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// SHORTCODE GENERATOR OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options       = array();

// -----------------------------------------
// Basic Shortcode Examples                -
// -----------------------------------------
$options[]     = array(
  'title'      => esc_html('Basic Shortcode Examples','cs-framework'),
  'shortcodes' => array(

    // begin: shortcode
    array(
      'name'      => 'cs_shortcode_1',
      'title'     => esc_html('Basic Shortcode 1','cs-framework'),
      'fields'    => array(

        // shortcode option field
        array(
          'id'    => 'icon',
          'type'  => 'icon',
          'title' => esc_html('Icon','cs-framework'),
        ),

        array(
          'id'    => 'image',
          'type'  => 'image',
          'title' => esc_html('Image','cs-framework'),
        ),

        // shortcode option field
        array(
          'id'    => 'gallery',
          'type'  => 'gallery',
          'title' => esc_html('Gallery','cs-framework'),
        ),

        // shortcode option field
        array(
          'id'    => 'title',
          'type'  => 'text',
          'title' => esc_html('Title','cs-framework'),
        ),


        // shortcode option field
        array(
          'id'    => 'title',
          'type'  => 'text',
          'title' => esc_html('Title','cs-framework'),
        ),

        // shortcode content
        array(
          'id'    => 'content',
          'type'  => 'textarea',
          'title' => esc_html('Content','cs-framework'),
          'help'  => esc_html('Lorem Ipsum Dollar.','cs-framework'),
        )

      ),
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'      => 'cs_shortcode_2',
      'title'     => esc_html('Basic Shortcode 2','cs-framework'),
      'fields'    => array(

        array(
          'id'    => 'option_1',
          'type'  => 'text',
          'title' => esc_html('Option 1','cs-framework'),
          'help'  => esc_html('Lorem Ipsum Dollar.','cs-framework'),
        ),

        array(
          'id'    => 'option_2',
          'type'  => 'text',
          'title' => esc_html('Option 2','cs-framework'),
        ),

        array(
          'id'    => 'option_3',
          'type'  => 'text',
          'title' => esc_html('Option 3','cs-framework'),
        ),

        array(
          'id'    => 'content',
          'type'  => 'textarea',
          'title' => esc_html('Content','cs-framework'),
        )

      ),
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'      => 'cs_shortcode_3',
      'title'     => esc_html('Basic Shortcode 3','cs-framework'),
      'fields'    => array(

        array(
          'id'         => 'title',
          'type'       => 'text',
          'title'      => esc_html('Title','cs-framework'),
        ),

        array(
          'id'         => 'active',
          'type'       => 'switcher',
          'title'      => esc_html('Active','cs-framework'),
          'label'      => esc_html('You you want to it ?','cs-framework'),
        ),

        array(
          'id'         => 'car',
          'type'       => 'select',
          'title'      => esc_html('Your car','cs-framework'),
          'options'    => array(
            'bmw'      => esc_html('BMW','cs-framework'),
            'mercedes' => esc_html('Mercedes','cs-framework'),
            'opel'     => esc_html('Opel','cs-framework'),
            'ferrari'  => esc_html('Ferrari''cs-framework'),
          )
        ),

        array(
          'id'         => 'content',
          'type'       => 'textarea',
          'title'      => esc_html('Content','cs-framework'),
        )

      ),
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'      => 'cs_shortcode_4',
      'title'     => esc_html('Basic Shortcode 4','cs-framework'),
      'fields'    => array(

        array(
          'id'         => 'title',
          'type'       => 'text',
          'title'      => esc_html('Title','cs-framework'),
        ),

        array(
          'id'         => 'active',
          'type'       => 'radio',
          'title'      => esc_html('Active','cs-framework'),
          'options'    => array(
            'yes'      => esc_html('Yes, Please.','cs-framework'),
            'no'       => esc_html('No, Thank you.','cs-framework'),
          )
        ),

        array(
          'id'         => 'cars',
          'type'       => 'checkbox',
          'title'      => esc_html('Select your cars','cs-framework'),
          'options'    => array(
            'bmw'      => esc_html('BMW','cs-framework'),
            'mercedes' => esc_html('Mercedes','cs-framework'),
            'open'     => esc_html('Opel','cs-framework'),
            'ferrari'  => esc_html('Ferrari''cs-framework'),
          )
        ),

        array(
          'id'         => 'avatar',
          'type'       => 'upload',
          'title'      => esc_html('Avatar','cs-framework'),
        ),

        array(
          'id'         => 'content',
          'type'       => 'textarea',
          'title'      => esc_html('Content','cs-framework'),
        )

      ),
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'      => 'cs_shortcode_5',
      'title'     => esc_html('Basic Shortcode 5','cs-framework'),
      'fields'    => array(

        array(
          'id'         => 'layout',
          'title'      => esc_html__('Layout','cs-framework'),
          'type'       => 'image_select',
          'options'    => array(
            'layout-1' => 'http://codestarframework.com/assets/images/placeholder/65x65-2ecc71.gif',
            'layout-2' => 'http://codestarframework.com/assets/images/placeholder/65x65-e74c3c.gif',
            'layout-3' => 'http://codestarframework.com/assets/images/placeholder/65x65-3498db.gif',
          ),
        ),

        array(
          'id'         => 'cars',
          'type'       => 'select',
          'title'      => esc_html__('Select your cars','cs-framework'),
          'options'    => array(
            'bmw'      => esc_html__('BMW','cs-framework'),
            'mercedes' => esc_html__('Mercedes','cs-framework'),
            'open'     => esc_html__('Opel','cs-framework'),
            'ferrari'  => esc_html__('Ferrari','cs-framework'),
            'jaguar'   => esc_html__('Jaguar','cs-framework'),
            'seat'     => esc_html__('Seat','cs-framework'),
          ),
          'attributes' => array(
            'multiple' => 'only-key',
            'style'    => 'width: 125px; height: 100px;',
          )
        ),

        array(
          'id'    => 'content',
          'type'  => 'textarea',
          'title' => esc_html__('Content','cs-framework'),
        )

      ),
    ),
    // end: shortcode

  ),
);

// -----------------------------------------
// Simple Shortcode Examples               -
// -----------------------------------------
$options[]     = array(
  'title'      => esc_html__('Simple Shortcode Examples','cs-framework'),
  'shortcodes' => array(

    // begin: shortcode
    array(
      'name'      => 'cs_simple_1',
      'title'     => esc_html__('Simple Shortcode 1','cs-framework'),
      'fields'    => array(

        array(
          'id'    => 'title',
          'type'  => 'text',
          'title' => esc_html__('Title','cs-framework'),
        ),

      ),
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'      => 'cs_simple_2',
      'title'     => esc_html__('Simple Shortcode 2','cs-framework'),
      'fields'    => array(

        array(
          'id'    => 'option_1',
          'type'  => 'text',
          'title' => esc_html__('Option 1','cs-framework'),
        ),

        array(
          'id'    => 'option_2',
          'type'  => 'text',
          'title' =>esc_html__( 'Option 2','cs-framework'),
        ),

        array(
          'id'    => 'option_3',
          'type'  => 'text',
          'title' => esc_html__('Option 3','cs-framework'),
        ),

      ),
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'      => 'cs_simple_3',
      'title'     => esc_html__('Simple Shortcode 3','cs-framework'),
      'fields'    => array(

        array(
          'id'         => 'title',
          'type'       => 'text',
          'title'      => esc_html__('Title','cs-framework'),
        ),

        array(
          'id'         => 'active',
          'type'       => 'switcher',
          'title'      => esc_html__('Active','cs-framework'),
          'label'      => esc_html__('You you want to it ?','cs-framework'),
        ),

        array(
          'id'         => 'car',
          'type'       => 'select',
          'title'      => esc_html__('Your car','cs-framework'),
          'options'    => array(
            'bmw'      => esc_html__('BMW','cs-framework'),
            'mercedes' => esc_html__('Mercedes','cs-framework'),
            'opel'     => esc_html__('Opel','cs-framework'),
            'ferrari'  => esc_html__('Ferrari''cs-framework'),
          )
        ),

      ),
    ),
    // end: shortcode

  ),
);

// -----------------------------------------
// Single Shortcode Examples               -
// -----------------------------------------
$options[]     = array(
  'title'      => esc_html__('Single Shortcode Examples','cs-framework'),
  'shortcodes' => array(

    // begin: shortcode
    array(
      'name'      => 'cs_single_1',
      'title'     => esc_html__('Single Shortcode 1','cs-framework'),
      'fields'    => array(

        array(
          'type'    => 'content',
          'content' => esc_html__('Just click to "Insert Shortcode, this is adding a single shortcode','cs-framework'),
        ),

      ),
    ),
    // end: shortcode


    // begin: shortcode
    array(
      'name'      => 'cs_single_2',
      'title'     => esc_html__('Single Shortcode 2','cs-framework'),
      'fields'    => array(

        array(
          'type'    => 'content',
          'content' => esc_html__('Just click to "Insert Shortcode, this is adding a single shortcode','cs-framework'),
        ),

      ),
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'      => 'cs_single_3',
      'title'     => esc_html__('Single Shortcode 3','cs-framework'),
      'fields'    => array(

        array(
          'id'    => 'content',
          'type'  => 'textarea',
          'title' => esc_html__('Content','cs-framework'),
          'help'  => esc_html__('This is a single shortcode and there is only content.','cs-framework'),
        )

      ),
    ),
    // end: shortcode

  ),
);

// -----------------------------------------
// Advanced Shortcode Examples             -
// -----------------------------------------
$options[]     = array(
  'title'      => esc_html('Advanced Shortcode Examples','cs-framework'),
  'shortcodes' => array(

    // begin: shortcode
    array(
      'name'           => esc_html('cs_advanced_1','cs-framework'),
      'title'          => esc_html('Duplicate Shortcode','cs-framework'),
      'view'           => 'clone_duplicate',
      'clone_title'    => esc_html('Add New','cs-framework'),
      'clone_fields'   => array(

        array(
          'id'         => 'title',
          'type'       => 'text',
          'title'      => esc_html('Title','cs-framework'),
        ),

        array(
          'id'         => 'content',
          'type'       => 'textarea',
          'title'      => esc_html('Content','cs-framework'),
        ),

      )
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'          => 'cs_advanced_3',
      'title'         => esc_html('Duplicate Group Shortcode','cs-framework'),
      'view'          => 'clone',
      'clone_id'      => 'cs_advanced_3_sub',
      'clone_title'   => esc_html('Add New','cs-framework'),
      'fields'        => array(

        array(
          'id'        => 'option_1',
          'type'      => 'text',
          'title'     => esc_html('Option 1','cs-framework'),
        ),

        array(
          'id'        => 'option_2',
          'type'      => 'select',
          'title'     => esc_html('Option 2','cs-framework'),
          'shortcodes'   => array(
            'value-1' =>  esc_html('Value 1','cs-framework'),
            'value-2' =>  esc_html('Value 2','cs-framework'),
            'value-3' =>  esc_html('Value 3','cs-framework'),
          ),
        ),

      ),
      'clone_fields'  => array(

        array(
          'id'        => 'title',
          'type'      => 'text',
          'title'     => esc_html__('Tab Title','cs-framework'),
        ),

        array(
          'id'        => 'content',
          'type'      => 'textarea',
          'title'     => esc_html__('Content','cs-framework'),
        ),
      )
    ),
    // end: shortcode

    // begin: shortcode
    array(
      'name'           => 'cs_advanced_4',
      'title'          => esc_html__('Contents Shortcode','cs-framework'),
      'view'           => 'contents',
      'fields'         => array(

        array(
          'id'         => 'content_1',
          'type'       => 'textarea',
          'title'      => esc_html__('Content 1','cs-framework'),
        ),

        array(
          'id'         => 'content_2',
          'type'       => 'textarea',
          'title'      => esc_html__('Content 2','cs-framework'),
        )

      ),
    ),
    // end: shortcode

  ),
);

CSFramework_Shortcode_Manager::instance( $options );
