<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options      = array();

// -----------------------------------------
// Page Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_custom_page_options',
  'title'     => esc_html__('Custom Page Options','cs-framework'),
  'post_type' => 'page',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    // begin: a section
    array(
      'name'  => 'section_1',
      'title' => esc_html__('Section 1','cs-framework'),
      'icon'  => esc_attr__('fa fa-cog','cs-framework'),

      // begin: fields
      'fields' => array(

        // begin: a field
        array(
          'id'    => 'section_1_text',
          'type'  => 'text',
          'title' => esc_html__('Text Field','cs-framework'),
        ),
        // end: a field

        array(
          'id'    => 'section_1_textarea',
          'type'  => 'textarea',
          'title' => esc_html__('Textarea Field','cs-framework'),
        ),

        array(
          'id'    => 'section_1_upload',
          'type'  => 'upload',
          'title' => esc_html__('Upload Field','cs-framework'),
        ),

        array(
          'id'    => 'section_1_switcher',
          'type'  => 'switcher',
          'title' => esc_html__('Switcher Field',
          'label' => esc_html__('Yes, Please do it.','cs-framework'),
        ),

      ), // end: fields
    ), // end: a section

    // begin: a section
    array(
      'name'  => 'section_2',
      'title' => esc_html__('Section 2',
      'icon'  => esc_attr('fa fa-tint','cs-framework'),
      'fields' => array(

        array(
          'id'      => 'section_2_color_picker_1',
          'type'    => 'color_picker',
          'title'   => esc_html__('Color Picker 1','cs-framework'),
          'default' => '#2ecc71',
        ),

        array(
          'id'      => 'section_2_color_picker_2',
          'type'    => 'color_picker',
          'title'   => esc_html__('Color Picker 2','cs-framework'),
          'default' => '#3498db',
        ),

        array(
          'id'      => 'section_2_color_picker_3',
          'type'    => 'color_picker',
          'title'   => esc_html__('Color Picker 3','cs-framework'),
          'default' => '#9b59b6',
        ),

        array(
          'id'      => 'section_2_color_picker_4',
          'type'    => 'color_picker',
          'title'   => esc_html__('Color Picker 4','cs-framework'),
          'default' => '#34495e',
        ),

        array(
          'id'      => 'section_2_color_picker_5',
          'type'    => 'color_picker',
          'title'   => esc_html__('Color Picker 5','cs-framework'),
          'default' => '#e67e22',
        ),

      ),
    ),
    // end: a section

  ),
);

// -----------------------------------------
// Page Side Metabox Options               -
// -----------------------------------------
$options[]    = array(
  'id'        => '_custom_page_side_options',
  'title'     => esc_html__('Custom Page Side Options','cs-framework'),
  'post_type' => 'page',
  'context'   => 'side',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'section_3',
      'fields' => array(

        array(
          'id'        => 'section_3_image_select',
          'type'      => 'image_select',
          'options'   => array(
            'value-1' => 'http://codestarframework.com/assets/images/placeholder/65x65-2ecc71.gif',
            'value-2' => 'http://codestarframework.com/assets/images/placeholder/65x65-e74c3c.gif',
            'value-3' => 'http://codestarframework.com/assets/images/placeholder/65x65-3498db.gif',
          ),
          'default'   => 'value-2',
        ),

        array(
          'id'            => 'section_3_text',
          'type'          => 'text',
          'attributes'    => array(
            'placeholder' => esc_html__('do stuff','cs-framework'),
          )
        ),

        array(
          'id'      => 'section_3_switcher',
          'type'    => 'switcher',
          'label'   => esc_html__('Are you sure ?','cs-framework'),
          'default' => true
        ),

      ),
    ),

  ),
);

// -----------------------------------------
// Post Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_custom_post_options',
  'title'     => esc_html__('Custom Post Options','cs-framework'),
  'post_type' => 'post',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'section_4',
      'fields' => array(

        array(
          'id'    => 'section_4_text',
          'type'  => 'text',
          'title' => esc_html__('Text Field','cs-framework'),
        ),

        array(
          'id'    => 'section_4_textarea',
          'type'  => 'textarea',
          'title' => esc_html__('Textarea Field','cs-framework'),
        ),

        array(
          'id'    => 'section_4_upload',
          'type'  => 'upload',
          'title' => esc_html__('Upload Field','cs-framework'),
        ),

        array(
          'id'    => 'section_4_switcher',
          'type'  => 'switcher',
          'title' => esc_html__('Switcher Field','cs-framework'),
          'label' => esc_html__('Yes, Please do it.','cs-framework'),
        ),

      ),
    ),

  ),
);

CSFramework_Metabox::instance( $options );
