<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// CUSTOMIZE SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options              = array();

// -----------------------------------------
// Customize Core Fields                   -
// -----------------------------------------
$options[]            = array(
  'name'              => 'wp_core_fields',
  'title'             => esc_html__('WP Core Fields','cs-framework'),
  'settings'          => array(

    // color
    array(
      'name'          => 'color_option_with_default',
      'default'       => '#d80039',
      'control'       => array(
        'label'       => esc_html__('Color','cs-framework'),
        'type'        => 'color',
      ),
    ),

    // text
    array(
      'name'          => 'text_option',
      'control'       => array(
        'label'       => esc_html__('Text','cs-framework'),
        'type'        => 'text',
      ),
    ),

    // text with default
    array(
      'name'          => 'text_option_with_default',
      'default'       => esc_html__('bla bla bla','cs-framework'),
      'control'       => array(
        'label'       => esc_html__('Text with Default','cs-framework'),
        'type'        => 'text',
      ),
    ),

    // textarea
    array(
      'name'          => 'textarea_option',
      'control'       => array(
        'label'       => esc_html__('Textarea','cs-framework'),
        'type'        => 'textarea',
      ),
    ),

    // checkbox
    array(
      'name'          => 'checkbox_option',
      'control'       => array(
        'label'       => esc_html__('Checkbox','cs-framework'),
        'type'        => 'checkbox',
      ),
    ),

    // radio
    array(
      'name'          => 'radio_option',
      'control'       => array(
        'label'       => esc_html__('Radio','cs-framework'),
        'type'        => 'radio',
        'choices'     => array(
          'key1'      => esc_html__('value 1','cs-framework'),
          'key2'      => esc_html__('value 2','cs-framework'),
          'key3'      => esc_html__('value 3','cs-framework'),
        )
      ),
    ),

    // select
    array(
      'name'          => 'select_option',
      'control'       => array(
        'label'       => esc_html__('Select','cs-framework'),
        'type'        => 'select',
        'choices'     => array(
          ''          => esc_html__('- Select a value -','cs-framework'),
          'key1'      => esc_html__('value 1','cs-framework'),
          'key2'      => esc_html__('value 2','cs-framework'),
          'key3'      => esc_html__('value 3','cs-framework'),
        )
      ),
    ),

    // dropdown-pages
    array(
      'name'          => 'dropdown_pages_option',
      'control'       => array(
        'label'       => esc_html__('Dropdown-Pages','cs-framework'),
        'type'        => 'dropdown-pages',
      ),
    ),

    // upload
    array(
      'name'          => 'upload_option',
      'control'       => array(
        'label'       => esc_html__('Upload','cs-framework'),
        'type'        => 'upload',
      ),
    ),

    // image
    array(
      'name'          => 'image_option',
      'control'       => array(
        'label'       => esc_html__('Image','cs-framework'),
        'type'        => 'image',
      ),
    ),

    // media
    array(
      'name'          => 'media_option',
      'control'       => array(
        'label'       => esc_html__('Media','cs-framework'),
        'type'        => 'media',
      ),
    ),

  )
);

// -----------------------------------------
// Customize Codestar Fields               -
// -----------------------------------------
$options[]            = array(
  'name'              => 'codestar_fields',
  'title'             => esc_html__('Codestar Framework Fields','cs-framework'),
  'settings'          => array(

    // codestar color picker
    array(
      'name'          => 'codestar_color_picker',
      'default'       => '#3498db',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'color_picker',
          'title'     => esc_html__('Color Picker Field','cs-framework'),
        ),
      ),
    ),

    // codestar text
    array(
      'name'          => 'codestar_text',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'text',
          'desc'      => esc_html__('Codestar Switcher Field','cs-framework'),
          'title'     => esc_html__('Text Field','cs-framework'),
        ),
      ),
    ),

    // codestar textarea
    array(
      'name'          => 'codestar_textarea',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'textarea',
          'title'     => esc_html__('Text Area','cs-framework'),
        ),
      ),
    ),

    // codestar switcher
    array(
      'name'          => 'codestar_switcher',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'switcher',
          'title'     => esc_html('Codestar Switcher Field','cs-framework'),
          'label'     => esc_html('Do you want to ?','cs-framework'),
          'help'      => esc_html__('Lorem Ipsum Dollar','cs-framework'),
        ),
      ),
    ),

    // codestar upload
    array(
      'name'          => 'codestar_upload',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'upload',
          'title'     => esc_html('Codestar Upload Field','cs-framework'),
        ),
      ),
    ),

    // codestar image
    array(
      'name'          => 'codestar_image',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'image',
          'title'     => esc_html__('Codestar Image Field','cs-framework'),
        ),
      ),
    ),

    // codestar gallery
    array(
      'name'          => 'codestar_gallery',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'gallery',
          'title'     => esc_html__('Codestar Gallery Field','cs-framework'),
        ),
      ),
    ),

    // codestar icon
    array(
      'name'          => 'codestar_icon',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'icon',
          'title'     => esc_html__('Codestar Icon Field','cs-framework'),
        ),
      ),
    ),

    // codestar image select
    array(
      'name'          => 'codestar_image_select',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'image_select',
          'title'     => esc_html__('Codestar Image Select Field','cs-framework'),
          'options'   => array(
            'value-1' => 'http://codestarframework.com/assets/images/placeholder/65x65-2ecc71.gif',
            'value-2' => 'http://codestarframework.com/assets/images/placeholder/65x65-e74c3c.gif',
            'value-3' => 'http://codestarframework.com/assets/images/placeholder/65x65-3498db.gif',
          ),
          'radio'     => true,
        ),
      ),
    ),

    // codestar heading
    array(
      'name'          => 'codestar_heading',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'heading',
          'content'   => esc_html__('Codestar Heading','cs-framework'),
        ),
      ),
    ),

    // codestar subheading
    array(
      'name'          => 'codestar_subheading',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'subheading',
          'content'   => esc_html__('Codestar Sub-Heading','cs-framework'),
        ),
      ),
    ),

    // codestar notice:success
    array(
      'name'          => 'codestar_notice_success',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'notice',
          'class'     => esc_attr__('success','cs-framework'),
          'content'   => esc_html__('Notice Success: Lorem Ipsum...','cs-framework'),
        ),
      ),
    ),

    // codestar notice:info
    array(
      'name'          => 'codestar_notice_info',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'notice',
          'class'     => esc_attr__('info','cs-framework'),
          'content'   => esc_html__('Notice Info: Lorem Ipsum...','cs-framework'),
        ),
      ),
    ),

    // codestar notice:danger
    array(
      'name'          => 'codestar_notice_danger',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'notice',
          'class'     => esc_attr__('danger','cs-framework'),
          'content'   => esc_html('Notice Danger: Lorem Ipsum...','cs-framework'),
        ),
      ),
    ),

    // codestar content
    array(
      'name'          => 'codestar_content',
      'control'       => array(
        'type'        => 'cs_field',
        'options'     => array(
          'type'      => 'content',
          'content'   => esc_html('Simple Content Field...','cs-framework'),
        ),
      ),
    ),

  )
);

// -----------------------------------------
// Customize Panel Options Fields          -
// -----------------------------------------
$options[]            = array(
  'name'              => 'codestar_panel_1',
  'title'             => esc_html('Codestar Framework Panel','cs-framework'),
  'description'       => esc_html('Codestar customize panel description.','cs-framework'),
  'sections'          => array(

    // begin: section
    array(
      'name'          => 'section_1',
      'title'         => esc_html('Section 1','cs-framework'),
      'settings'      => array(

        array(
          'name'      => 'color_option_1',
          'default'   => '#ffbc00',
          'control'   => array(
            'type'    => 'cs_field',
            'options' => array(
              'type'  => 'color_picker',
              'title' => esc_html('Color Option 1','cs-framework'),
            ),
          ),
        ),

        array(
          'name'      => 'color_option_2',
          'default'   => '#2ecc71',
          'control'   => array(
            'type'    => 'cs_field',
            'options' => array(
              'type'  => 'color_picker',
              'title' => esc_html('Color Option 2','cs-framework'),
            ),
          ),
        ),

        array(
          'name'      => 'color_option_3',
          'default'   => '#e74c3c',
          'control'   => array(
            'type'    => 'cs_field',
            'options' => array(
              'type'  => 'color_picker',
              'title' => esc_html('Color Option 3','cs-framework'),
            ),
          ),
        ),

        array(
          'name'      => 'color_option_4',
          'default'   => '#3498db',
          'control'   => array(
            'type'    => 'cs_field',
            'options' => array(
              'type'  => 'color_picker',
              'title' => esc_html('Color Option 4','cs-framework'),
            ),
          ),
        ),

        array(
          'name'      => 'color_option_5',
          'default'   => '#555555',
          'control'   => array(
            'type'    => 'cs_field',
            'options' => array(
              'type'  => 'color_picker',
              'title' => esc_html('Color Option 5','cs-framework'),
            ),
          ),
        ),

      ),
    ),
    // end: section

    // begin: section
    array(
      'name'          => 'section_2',
      'title'         => esc_html__('Section 2','cs-framework'),
      'settings'      => array(

        array(
          'name'      => 'text_option_1',
          'control'   => array(
            'type'    => 'cs_field',
            'options' => array(
              'type'  => 'text',
              'title' => esc_html__('Text Option 1','cs-framework'),
            ),
          ),
        ),

        array(
          'name'      => 'text_option_2',
          'control'   => array(
            'type'    => 'cs_field',
            'options' => array(
              'type'  => 'text',
              'title' => esc_html__('Text Option 2','cs-framework'),
            ),
          ),
        ),

        array(
          'name'      => 'text_option_3',
          'control'   => array(
            'type'    => 'cs_field',
            'options' => array(
              'type'  => 'text',
              'title' => esc_html__('Text Option 3','cs-framework'),
            ),
          ),
        ),

      ),
    ),
    // end: section

  ),
  // end: sections

);

CSFramework_Customize::instance( $options );
