<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_title_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-title';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Title', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'title' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_title_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_small_title',
			[
			    'label' => esc_html__( 'Small Title', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Small Title','socitycore'),
			]
		);
		$this->add_control(
			'socity_title',
			[
			    'label' => esc_html__( 'Hadding', 'socitycore' ),
			    'type' => Controls_Manager::WYSIWYG,
			    'default' => esc_html__( 'We work creatively and specially for our clients You can check out our work.','socitycore' ),
			    'placeholder' => esc_html__( 'Title Hadding', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_title_btn_enable',
			[
				'label' => esc_html__( 'Enable Buttons', 'socitycore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'socitycore' ),
				'label_off' => esc_html__( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'socity_title_buttons_links',
			[
				'label' => esc_html__( 'Select Link', 'socitycore' ),
				'type'  => Controls_Manager::SELECT,
				'default'	=> 'extranal',
				'options' => [
					'extranal' => esc_html__( 'Extranal', 'socitycore' ),
					'page' =>  esc_html__( 'Page', 'socitycore' ),
				],
				'condition' => [
					'socity_title_btn_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'socity_title_buttons_link_extralnal',
			[
				'label' => esc_html__( 'Extranal Link', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'socity_title_buttons_links' => 'extranal',
					'socity_title_btn_enable' => 'yes',
				],
				'placeholder' => esc_html__( 'Add Extranal Link', 'socitycore' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'socity_title_buttons_page_link',
			[
				'label' => esc_html__( 'Page Link', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'options' => socity_page_list(),
				'condition' => [
					'socity_title_buttons_links' => 'page',
					'socity_title_btn_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'socity_title_buttons_readmore_link_test',
			[
			    'label' => esc_html__( 'Button Link Text', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Read More','socitycore'),
			    'condition' => [
					'socity_title_btn_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'socity_title_button_new_tab',
			[
			    'label'         => esc_html__( 'Open New Tab ? ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'Yes', 'socitycore' ),
			    'label_off'     => esc_html__( 'No', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'no',
			    'condition' => [
					'socity_title_btn_enable' => 'yes',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_title_styles',
			[
				'label' => esc_html__( 'Style', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'socity_title_tabs'
		);
		$this->start_controls_tab(
			'socity_title_stab',
			[
				'label' => esc_html__( 'Small Title', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_title_scolor',
			[
				'label' => esc_html__( 'Title Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .small-title' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_title_typrography',
			    'label' => esc_html__( 'Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .small-title',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'socity_title_hadding_tab',
			[
				'label' => esc_html__( 'Hadding', 'socitycore' ),
			]
		);
		
		$this->add_control(
			'socity_about_v_con_hcolor',
			[
				'label' => esc_html__( 'Hadding Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-hadding span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_title_htyprography',
			    'label' => esc_html__( 'Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .title-hadding span',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->add_responsive_control(
			'socity_title_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .title-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);        
		$this->add_responsive_control(
			'socity_title_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .title-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);  
		$this->add_responsive_control(
			'socity_title_alignment',
			[
			    'label' => __( 'Alignment', 'socitycore' ),
			    'type' => Controls_Manager::CHOOSE,
			    'options' => [
				  'left' => [
					'title' => esc_html__( 'Left', 'socitycore' ),
					'icon' => 'fa fa-align-left',
				  ],
				  'center' => [
					'title' => esc_html__( 'Center', 'socitycore' ),
					'icon' => 'fa fa-align-center',
				  ],
				  'right' => [
					'title' => esc_html__( 'Right', 'socitycore' ),
					'icon' => 'fa fa-align-right',
				  ]
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .title-box' => 'text-align: {{VALUE}};',
			    ],
			    'separator' =>'before',
			]
		  );
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_title_buttons_style',
			[
				'label' => esc_html__( 'Buttons', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'socitycore' ),
			    	'name' => 'socity_title_buttons_typo',
			    	'selector' => '{{WRAPPER}} .title-box .socity-theme-buttons a.theme-button',
			]
		);   
		$this->add_control(
			'socity_title_buttons_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-box .socity-theme-buttons a.theme-button' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_title_buttons_bg',
				'label' => esc_html__( 'background color', 'socitycore' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .title-box .socity-theme-buttons a.theme-button',
			]
		);
		$this->add_responsive_control(
			'socity_title_buttons_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .title-box .socity-theme-buttons a.theme-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);        
		$this->add_responsive_control(
			'socity_title_buttons_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'default' => [
					'top' => '17',
					'right' => '30',
					'bottom' => '17',
					'left' => '30',
					'isLinked' => false
			  	],
			    'selectors' => [
				 	 '{{WRAPPER}} .title-box .socity-theme-buttons a.theme-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    	],
			    'separator' =>'before',
			]
		);   
		$this->add_control(
			'btn_line',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'important_note',
			[
				'label' => __( '<strong>Button Hover Section</strong>', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
			]
		);
		$this->add_control(
			'socity_title_buttons_hcolor',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-box .socity-theme-buttons a.theme-button:hover' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_title_buttons_hbg',
				'label' => esc_html__( 'background color', 'socitycore' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .title-box .socity-theme-buttons a.theme-button:hover',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if( $settings['socity_title_buttons_page_link'] == 'page' ){
			$socity_title_btn_page = get_page_link( $settings['socity_title_buttons_page_link'] );
		}else{
			$socity_title_btn_page =  $settings['socity_title_buttons_link_extralnal'];
		}
		?>
		<div class="title-boxs">
			<div class="title-box">
				<?php if(!empty($settings['socity_small_title'])) : ?>
				<span class="small-title"><?php echo esc_html($settings['socity_small_title']); ?></span>
				<?php endif; ?>
				<?php if(!empty($settings['socity_title'])) : ?>
					<h2 class="title-hadding"><span><?php echo wp_kses_post(wpautop($settings['socity_title'])); ?></span></h2>
				<?php endif; ?>
				<?php if(!empty( $settings['socity_title_btn_enable'] == 'yes' )) : ?>
					<div class="socity-theme-buttons ">
						<div class="theme-buttons">
							<a <?php if(!empty($settings['socity_title_button_new_tab'] == 'yes' )) : ?>target="_blank"<?php endif; ?> href="<?php echo esc_url($socity_title_btn_page) ?>" class="theme-button colorbg">
								<?php echo esc_html($settings['socity_title_buttons_readmore_link_test']) ?><i class="flaticon-right-arrow"></i>
							</a>
						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_title_Widget );