<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_slider_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Slider', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'slider' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'socity_slider_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();
       
        $repeater->add_control(
			'socity_slider_image',
			[
				'label' => __( 'Choose Image', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
            'socity_slider_stitle', [
                'label' => esc_html__( 'Small Title', 'socitycore' ),
                'type' => Controls_Manager::TEXT,
                'show_label' => true,
            ]
        );
        $repeater->add_control(
            'socity_slider_title', [
                'label' => esc_html__( 'Title', 'socitycore' ),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __( 'Choose Your IT Solution For Good Business!' , 'socitycore' ),
                'show_label' => true,
            ]
        );
        $repeater->add_control(
            'socity_slider_content', [
                'label' => esc_html__( 'Content', 'socitycore' ),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __( 'Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh.sagittis magna.From helpdesk.' , 'socitycore' ),
                'show_label' => true,
            ]
        );
        $repeater->add_control(
			'socity_slider_btn_enable',
			[
				'label' => __( 'Button Enable', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $repeater->add_control(
			'socity_slider_btns',
			[
				'label' => esc_html__( 'Select Link', 'socitycore' ),
				'type'  => Controls_Manager::SELECT,
				'default'	=> 'extranal',
				'options' => [
					'extranal' => esc_html__( 'Extranal', 'socitycore' ),
					'page' =>  esc_html__( 'Page', 'socitycore' ),
				],
				'label_block' => true,
				'condition' => [
					'socity_slider_btn_enable' => 'yes',
				],
			]
		);
        $repeater->add_control(
			'socity_slider_extral',
			[
				'label' => esc_html__( 'Extranal Link', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'socity_slider_btns' => 'extranal',
				],
				'placeholder' => esc_html__( 'Add Extranal Link', 'socitycore' ),
				'label_block' => true,
				'condition' => [
					'socity_slider_btn_enable' => 'yes',
				],
			]
		);
		$repeater->add_control(
			'socity_slider_page_link',
			[
				'label' => esc_html__( 'Page Link', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'options' => socity_page_list(),
				'condition' => [
					'socity_slider_btns' => 'page',
				],
				'label_block' => true,
				'condition' => [
					'socity_slider_btn_enable' => 'yes',
				],
			]
		);
		$repeater->add_control(
			'socity_slider_btn_text',
			[
				'label' => esc_html__( 'Buttn Text', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'default'	=> esc_html__( 'Read More', 'socitycore' ),
				'label_block' => true,
				'condition' => [
					'socity_slider_btn_enable' => 'yes',
				],
			]
		);
		$repeater->add_control(
			'socity_slider_bideo_enable',
			[
				'label' => __( 'Enable Video button', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'socitycore' ),
				'label_off' => __( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$repeater->add_control(
			'socity_slider_video_link',
			[
				'label' => __( 'Video Link', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'socity_slider_bideo_enable' => 'yes',
				],
				'label_block' => true,
				'default' => 'https://www.youtube.com/watch?v=f3NWvUV8MD8',
			]
		);
		$repeater->add_control(
			'socity_slider_video_text',
			[
				'label' => __( 'Video Text', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'socity_slider_bideo_enable' => 'yes',
				],
				'label_block' => true,
			]
		);
        $this->add_control(
            'socity_sliders',
            [
                'label' => esc_html__( 'Slider List', 'socitycore' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'socity_slider_title' => __( 'Choose Your IT Solution For Good Business!', 'socitycore' ),
                        'socity_slider_content' => __('Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh.sagittis magna.From helpdesk. ', 'socitycore' ),
                        'socity_slider_btn_text' =>  __( 'Read More', 'socitycore' ),
                        'socity_slider_video_text' => __( 'Watch Our Video', 'socitycore' ),
                        'socity_slider_video_link' =>  'https://www.youtube.com/watch?v=f3NWvUV8MD8',
                    ],
                ],
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_slider_setting',
			[
				'label' => esc_html__( 'Settings', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
			'socity_slider_height',
			[
				'label' => esc_html__( 'Icon Radius', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 300,
						'max' => 1000,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 800,
				],
				'selectors' => [
					'{{WRAPPER}} .socity-slide-item' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_control(
			'socity_slider_slide_on',
			[
				'label'         => esc_html__( 'Enable Slider', 'socitycore' ),
			    	'type'          => Controls_Manager::SWITCHER,
			    	'label_on'      => esc_html__( 'On', 'socitycore' ),
			    	'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    	'return_value'  => 'yes',
			    	'default'       => 'yes',
			]
		);
		$this->add_control(
			'socity_slide_loop',
			[
			    'label'         => esc_html__( 'Enable Loop ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'yes',
			    'condition' 	=> [
                        	'socity_slider_slide_on' => 'yes',
                  	]
			]
		);
		$this->add_control(
			'socity_slide_aloop',
			[
			    'label'         => esc_html__( 'Enable Auto Loop ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'yes',
			    'condition' 	=> [
                        'socity_slide_loop' => 'yes',
                  	]
			]
		);
		$this->add_control(
			'socity_slide_aspeed',
			[
				'label' 	=> esc_html__( 'Slide auto Speed', 'socitycore' ),
			    	'type' 	=> Controls_Manager::NUMBER,
			    	'min' 	=> 200,
			    	'max' 	=> 5000,
			    	'step' 	=> 50,
			    	'default' 	=> 1000,
			   	'condition' => array(
					'socity_slide_aloop' 		=> 'yes',
					'socity_slide_loop' 		=> 'yes',
					'socity_slider_slide_on' 	=> 'yes',
					
				)
			]
		);
		$this->add_control(
			'socity_slide_speed',
			[
				'label' 	=> esc_html__( 'Slide Speed', 'socitycore' ),
			    	'type' 	=> Controls_Manager::NUMBER,
			    	'min' 	=> 200,
			    	'max' 	=> 5000,
			    	'step' 	=> 10,
			    	'default' 	=> 1000,
			]
		);
		$this->add_control(
			'socity_slide_nav',
			[
			    'label'         => esc_html__( 'Enable Nav ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'yes',
			    'condition' 	=> [
                        	'socity_slider_slide_on' => 'yes',
                  	]
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_slide_box_style',
			[
				'label' => esc_html__( 'Box', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'socity_slide_overly',
				'label' => __( 'Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .socity-slide-item:before',
			]
		);
		$this->add_responsive_control(
		'socity_slide_box_margin',
			[
				'label' => __( 'Margin', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .socity-slide-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_slide_box_padding',
			[
				'label' => __( 'Padding', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .socity-slide-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_slide_title_style',
			[
				'label' => esc_html__( 'Title', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'socity_slide_title_font',
				'label' => esc_html__( 'Typography', 'socitycore' ),
				'selector' => '{{WRAPPER}} .socity-slider-hadding h2',
			]
		); 
		$this->add_responsive_control(
			'socity_slide_title_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-slider-hadding h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
		'socity_slide_title_margin',
			[
				'label' => __( 'Margin', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .socity-slider-hadding h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_slide_title_padding',
			[
				'label' => __( 'Padding', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .socity-slider-hadding h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'subtitle_slider',
			[
				'label' => __( 'Sub Title', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'socity_slide_stitle_font',
				'label' => esc_html__( 'Typography', 'socitycore' ),
				'selector' => '{{WRAPPER}} .socity-slider-stitle span',
			]
		); 
		$this->add_responsive_control(
			'socity_slide_stitle_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-slider-stitle span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
		'socity_slide_stitle_margin',
			[
				'label' => __( 'Margin', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .socity-slider-stitle span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_slide_stitle_padding',
			[
				'label' => __( 'Padding', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .socity-slider-stitle span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_slide_dec_style',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'socity_slide_dec_font',
				'label' => esc_html__( 'Typography', 'socitycore' ),
				'selector' => '{{WRAPPER}} .socity-sldie-dec p',
			]
		); 
		$this->add_responsive_control(
			'socity_slide_dec_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-sldie-dec p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
		'socity_slide_dec_margin',
			[
				'label' => __( 'Margin', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .socity-sldie-dec p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_slide_dec_padding',
			[
				'label' => __( 'Padding', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .socity-sldie-dec p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_slide_readmore_style',
			[
				'label' => esc_html__( 'ReadMore Button', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'socity_slide_rbtn_font',
				'label' => esc_html__( 'Typography', 'socitycore' ),
				'selector' => '{{WRAPPER}} a.theme-button',
			]
		); 
		$this->add_responsive_control(
		'socity_slide_rbtn_margin',
			[
				'label' => __( 'Margin', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} a.theme-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_slide_rbtn_padding',
			[
				'label' => __( 'Padding', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} a.theme-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->start_controls_tabs(
			'socity_rbtn_tabs'
		);

		$this->start_controls_tab(
			'socity_rbtn_tab_n',
			[
				'label' => __( 'Normal', 'socitycore' ),
			]
		);
		$this->add_responsive_control(
			'socity_slide_rbtn_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.theme-button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'socity_slide_rbtn_bg',
				'label' => __( 'Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} a.theme-button',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'socity_slide_rbtn_shadow',
				'label' => __( 'Button Shadow', 'socitycore' ),
				'selector' => '{{WRAPPER}} a.theme-button',
			]
		);
		$this->add_control(
			'socity_slide_rbtn_radius',
			[
				'label' => __( 'Radius', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} a.theme-button' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'socity_rbtn_tab_h',
			[
				'label' => __( 'Hover', 'socitycore' ),
			]
		);
		$this->add_responsive_control(
			'socity_slide_rbtnh_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.theme-button:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'socity_slide_rbtnh_bg',
				'label' => __( 'Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} a.theme-button:hover',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'socity_slide_rbtnh_shadow',
				'label' => __( 'Button Shadow', 'socitycore' ),
				'selector' => '{{WRAPPER}} a.theme-button:hover',
			]
		);
		$this->add_control(
			'socity_slide_rbtnh_radius',
			[
				'label' => __( 'Radius', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} a.theme-button:hover' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_slide_video_btn_style',
			[
				'label' => esc_html__( 'Video Button', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_slide_vbtn_color',
			[
				'label' => esc_html__( 'Normal Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-slide-button.socity-slide-video a i:before' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'socity_slide_vbtnh_color',
			[
				'label' => esc_html__( 'Hover Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-slide-button.socity-slide-video a:hover i:before' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'socity_slide_vbtnt_color',
			[
				'label' => esc_html__( 'Text Normal Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-slide-button.socity-slide-video a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'socity_slide_vbtnht_color',
			[
				'label' => esc_html__( 'Text Hover Color', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-slide-button.socity-slide-video a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        	$dynamic_num = rand(35245545, 541541745);
        	if($settings['socity_slider_slide_on'] == 'yes' ){
				if($settings['socity_slide_aloop'] == 'yes' ){
					$aplay = 'true';
					}else{
					$aplay = 'false';
				}
				if($settings['socity_slide_nav'] == 'yes' ){
				$nav = 'true';
				}else{
				$nav = 'false';
				}
            echo '
			<script>
			jQuery(document).ready(function($) {
				"use strict";
				$(".slider-'.esc_attr($dynamic_num).'").slick({
					autoplay:'.esc_attr($aplay).',
					arrows:'.esc_attr($nav).',
					slidesToShow:1,
					slidesToScroll:1,';
                  if(!empty($settings['socity_slide_aspeed'])){
                        echo 'autoplaySpeed:'.esc_attr($settings['socity_slide_aspeed']).',';
                    }
                    if(!empty($settings['socity_slide_speed'])){
                        echo 'speed:'.esc_attr($settings['socity_slide_speed']).',';
                    }
            	echo '
				});
				$(".slider-popUp").videoPopup( {
				    autoplay: 1, controlsColor: "white", 
				    showVideoInformations: 0, 
				    width: 1000, 
				    customOptions: {
					  rel: 0, 
					  end: 60
				    }
				});
			});
			</script>';
		 }
		
		?>
		<div class="socity-sliders">
			<div class="socity-slide slider-<?php echo esc_attr($dynamic_num); ?>">
				<?php foreach ($settings['socity_sliders'] as $socity_slider) : 
					if($socity_slider['socity_slider_btns'] == 'page' ){
						$link = get_page_link( $socity_slider['socity_slider_page_link'] );
					}else{
						$link = $socity_slider['socity_slider_extral'];
					}
				?> 
				<div class="socity-slide-item" style="background-image:url( <?php echo esc_url(wp_get_attachment_image_url( $socity_slider['socity_slider_image']['id'], 'full' )); ?> )">
		 			<div class="socity-slider-table">
		 				<div class="socity-slider-table-call">
		 					<div class="container">
								<div class="row">
									<div class="col-12 col-sm-10 col-md-8 col-lg-8">
										<div class="socity-slide-content">
											<?php if(!empty($socity_slider['socity_slider_stitle'])) : ?>
											<div class="socity-slider-stitle">
												<span><?php echo esc_html($socity_slider['socity_slider_stitle']); ?></span>
											</div>
											<?php endif; ?>
											<div class="socity-slider-hadding">
												<?php echo wp_kses_post(wpautop($socity_slider['socity_slider_title'])); ?>
											</div>
											<div class="socity-sldie-dec">
												<?php echo wp_kses_post(wpautop($socity_slider['socity_slider_content'])); ?>
											</div>
											<div class="socity-slide-buttons">
												<?php if(!empty($socity_slider['socity_slider_btn_enable'] == 'yes' )) : ?>
												<div class="socity-slide-button">
													<a href="<?php echo esc_url($link); ?>" class="theme-button colorbg">
														<?php echo esc_html($socity_slider['socity_slider_btn_text']); ?><i class="flaticon-right-arrow"></i></a>
												</div>
												<?php endif; ?>
												<?php if(!empty($socity_slider['socity_slider_bideo_enable'] == 'yes' )) : ?>
												<div class="socity-slide-button socity-slide-video">
													<a href="#" data-video-url="<?php echo esc_url($socity_slider['socity_slider_video_link']); ?>" class="slider-popUp"><i class="flaticon-play-button-1"></i> <?php echo esc_html($socity_slider['socity_slider_video_text']) ?></a>
												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_slider_Widget );