<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_project_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-project';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Project', 'socitycore' );
	}


	public function get_categories() {
		return [ 'socitycore' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'project' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'socity_projects_contnet',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_project_stitle',
			[
			    'label' => esc_html__( 'Small Title', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Latest Project','socitycore'),
			]
		);
		$this->add_control(
			'socity_project_hadding',
			[
			    'label' => esc_html__( 'Hadding', 'socitycore' ),
			    'type' => Controls_Manager::TEXTAREA,
			    'default' => esc_html__( 'There are more latest project done yet.','socitycore' ),
			    'placeholder' => esc_html__( 'Hadding', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_project_style',
			[
				'label' => esc_html__( 'Select Style', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => esc_html__( 'Style One', 'socitycore' ),
					'2'  => esc_html__( 'Style Two', 'socitycore' ),
					'3'  => esc_html__( 'Style Three', 'socitycore' ),
				],
			]
		);
		$this->add_control(
			'socity_project_enable_sliders',
			[
				'label' => esc_html__( 'Enable Slide ?', 'socitycore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'socitycore' ),
				'label_off' => esc_html__( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'socity_project_style' => '1',
				]
			]
		);
		
		$this->add_control(
			'socity_project_nav',
			[
				'label' => esc_html__( 'Enable Nav', 'socitycore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'socitycore' ),
				'label_off' => esc_html__( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'socity_project_style' => '1',
					'socity_project_enable_sliders' => 'yes',
				]
			]
		);
		$this->add_control(
			'socity_project_aplay',
			[
				'label' => esc_html__( 'Enable Auto Play', 'socitycore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'socitycore' ),
				'label_off' => esc_html__( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'socity_project_style' => '1',
					'socity_project_enable_sliders' => 'yes',
				]
			]
		);
		$this->add_control(
			'socity_project_aspeed_enable',
			[
				'label' => esc_html__( 'Enable Auto Play Speed', 'socitycore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'socitycore' ),
				'label_off' => esc_html__( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'socity_project_style' => '1',
					'socity_project_enable_sliders' => 'yes',
				]
			]
		);
		$this->add_control(
			'socity_project_aspeed',
			[
				'label' 	=> esc_html__( 'Slide auto Speed', 'socitycore' ),
			    	'type' 	=> Controls_Manager::NUMBER,
			    	'min' 	=> 500,
			    	'max' 	=> 5000,
			    	'step' 	=> 50,
			    	'default' 	=> 1500,
			   	'condition' => array(
					'socity_project_style' => '1',
					'socity_project_aspeed_enable' => 'yes',
					'socity_project_enable_sliders' => 'yes',

				)
			]
		);
		$this->add_control(
			'socity_project_speed_enable',
			[
				'label' => esc_html__( 'Enable Speed', 'socitycore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'socitycore' ),
				'label_off' => esc_html__( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'socity_project_style' => '1',
					'socity_project_enable_sliders' => 'yes',
				]
			]
		);
		$this->add_control(
			'socity_project_speed',
			[
				'label' 	=> esc_html__( 'Slide Speed', 'socitycore' ),
			    	'type' 	=> Controls_Manager::NUMBER,
			    	'min' 	=> 500,
			    	'max' 	=> 5000,
			    	'step' 	=> 50,
			    	'default' 	=> 1500,
			   	'condition' => array(
					'socity_project_style' => '1',
					'socity_project_speed_enable' => 'yes',
					'socity_project_enable_sliders' => 'yes',

				)
			]
		);
		$this->add_responsive_control(
			'socity_project_vicon_position',
			[
			    'label' => esc_html__( 'video Icon position', 'socitycore' ),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => [ 'px', '%' ],
			    'range' => [
				  'px' => [
					'min' => -200,
					'max' => 200,
					'step' => 1,
				  ],
				  '%' => [
					'min' => -100,
					'max' => 100,
				  ],
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .project-video' => 'top: {{SIZE}}{{UNIT}};'
			    ],
			]
		);
		$this->add_responsive_control(
			'socity_project_button_position',
			[
			    'label' => esc_html__( 'button Position Bottom', 'socitycore' ),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => [ 'px', '%' ],
			    'range' => [
				  'px' => [
					'min' => -100,
					'max' => 500,
					'step' => 1,
				  ],
				  '%' => [
					'min' => -100,
					'max' => 100,
				  ],
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .project-box .project-title' => 'bottom: {{SIZE}}{{UNIT}};'
			    ],
			]
		);
		$this->add_responsive_control(
			'socity_project_button_position_r',
			[
			    'label' => esc_html__( 'button Position Right', 'socitycore' ),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => [ 'px', '%' ],
			    'range' => [
				  'px' => [
					'min' => -100,
					'max' => 500,
					'step' => 1,
				  ],
				  '%' => [
					'min' => -100,
					'max' => 100,
				  ],
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .project-box .project-title' => 'right: {{SIZE}}{{UNIT}};'
			    ],
			]
		);
		$this->add_control(
			'socity_project_per_post',
			[
			    'label' => esc_html__( 'Show Items', 'socitycore' ),
			   'type' 	=> Controls_Manager::NUMBER,
			    	'min' 	=> -1,
			    	'max' 	=> 15,
			    	'step' 	=> 1,
			    	'default' 	=> -1,
			]
		);
		$this->add_control(
			'socity_project_pagi',
			[
				'label' => esc_html__( 'Enable Pagination', 'socitycore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'socitycore' ),
				'label_off' => esc_html__( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_project_hadding_style',
			[
				'label' => esc_html__( 'Hadding', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
            'socity_project_hsaline',
			[
			'label' => esc_html__( 'Alignment', 'socitycore' ),
			'type' => Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'socitycore' ),
					'icon' => 'fa fa-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'socitycore' ),
					'icon' => 'fa fa-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'socitycore' ),
					'icon' => 'fa fa-align-right',
				],
				'justify' => [
					'title' => esc_html__( 'Justified', 'socitycore' ),
					'icon' => 'fa fa-align-justify',
				],
			],
			'selectors' => [
				'{{WRAPPER}} .project-hadding' => 'text-align: {{VALUE}};',
			],
			'default' => 'left',
			'separator' =>'before',
			]
		);
		$this->add_control(
			'socity_project_hscolor',
			[
				'label' => esc_html__( 'Small Text Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0b5be0',
				'selectors' => [
					'{{WRAPPER}} .project-hadding span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_project_stypo',
			    'label' => esc_html__( 'Small Text Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .project-hadding span',
			]
		);
		$this->add_control(
			'socity_project_hcolor',
			[
				'label' => esc_html__( 'Hadding Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .project-hadding h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_project_h_padding_right',
			[
			    'label' => esc_html__( 'Hadding margin Right', 'socitycore' ),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => [ 'px', '%' ],
			    'range' => [
				  'px' => [
					'min' => 0,
					'max' => 500,
					'step' => 1,
				  ],
				  '%' => [
					'min' => 10,
					'max' => 100,
				  ],
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .project-hadding h2' => 'margin-right: {{SIZE}}{{UNIT}};'
			    ],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_project_typo',
			    'label' => esc_html__( ' Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .project-hadding h2',
			]
		);
		$this->add_responsive_control(
			'socity_project_hpadding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .project-haddings' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_project_tab_menu_style',
			[
				'label' => esc_html__( 'Category Menu', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_project_mtypo',
			    'label' => esc_html__( ' Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .project-menu ul li',
			]
		);
		$this->add_control(
			'socity_project_mcolor',
			[
				'label' => esc_html__( 'Menu color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .project-menu ul li' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'socity_project_macolor',
			[
				'label' => esc_html__( 'Active color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .project-menu ul li.active' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_project_mbcolor',
				'label' => esc_html__( 'active Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .project-menu ul li.active',
			]
		);
		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_project_note',
			[
				'label' => __( '<strong>Hover Section</strong>', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
			]
		);
		$this->add_control(
			'socity_project_mhscolor',
			[
				'label' => esc_html__( 'Hover color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .project-menu ul li:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_project_mbhcolor',
				'label' => esc_html__( 'Hover Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .project-menu ul li:hover',
			]
		);
		$this->add_responsive_control(
			'socity_project_mmargin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'default' => [
				  'top' => '5',
				  'right' => '5',
				  'bottom' => '5',
				  'left' => '5',
				  'isLinked' => false
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .project-menu ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->add_responsive_control(
			'socity_project_mpadding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'default' => [
				  'top' => '11',
				  'right' => '25',
				  'bottom' => '11',
				  'left' => '25',
				  'isLinked' => false
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .project-menu ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_project_item_style',
			[
				'label' => esc_html__( 'Item', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'socity_project_item_icon_color',
			[
				'label' => esc_html__( 'Icon color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .project-video a i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'socity_project_item_icon_hcolor',
			[
				'label' => esc_html__( 'Icon Hover color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0b5be0',
				'selectors' => [
					'{{WRAPPER}} .project-video a:hover i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'hr1',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_project_note1',
			[
				'label' => __( '<strong>Button Normal Section</strong>', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
			]
		);
		$this->add_control(
			'socity_project_ib_color',
			[
				'label' => esc_html__( 'button Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .project-title a.theme-button' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_project_ib_bg',
				'label' => esc_html__( 'Button Background Color', 'socitycore' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .project-title a.theme-button',
			]
		);
		$this->add_control(
			'hr2',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_project_note2',
			[
				'label' => __( '<strong>Button Hover Section</strong>', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
			]
		);
		$this->add_control(
			'socity_project_ib_hcolor',
			[
				'label' => esc_html__( 'button Hover Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .project-title a.theme-button:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_project_ib_hbg',
				'label' => esc_html__( 'Button Background Color', 'socitycore' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .project-title a.theme-button:hover',
			]
		);
		$this->add_control(
			'hr3',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_project_note3',
			[
				'label' => __( '<strong>image Hover background color</strong>', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_project_im_hbg',
				'label' => esc_html__( 'Background Color', 'socitycore' ),
				'types' => [ 'classic', 'gradient' ],
				'default' => 'rgba(0, 0, 0, 0.52)',
				'selector' => '{{WRAPPER}} .project-signle:after',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_project_box_style',
			[
				'label' => esc_html__( 'Box', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_project_box_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '95px',
					'right' => '0',
					'bottom' => '0',
					'left' => '0',
					'isLinked' => false
				],
			    'selectors' => [
				  '{{WRAPPER}} .project-boxs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->add_responsive_control(
			'socity_project_box_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'default' => [
					'top' => '0',
					'right' => '0',
					'bottom' => '0',
					'left' => '0',
					'isLinked' => false
				],
			    	'selectors' => [
					'{{WRAPPER}} .project-boxs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    	],
			    'separator' =>'before',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$dynamic_id = rand(1241, 3256);
		if($settings['socity_project_enable_sliders'] == 'yes' ){
			if($settings['socity_project_aplay'] == 'yes' ){
				$aplay = 'true';
			}else{
				$aplay = 'false';
			}
			if($settings['socity_project_nav'] == 'yes' ){
				$nav = 'true';
			}else{
				$nav = 'false';
			}
			echo '
			<script>
			jQuery(document).ready(function($) {
				"use strict";
				$("#project-'.esc_attr($dynamic_id).'").slick({
					autoplay:'.esc_attr($aplay).',
					arrows:'.esc_attr($nav).',
					slidesToShow:3,
					slidesToScroll:1,';
					if(!empty($settings['socity_project_aspeed'])){
						echo 'autoplaySpeed:'.esc_attr($settings['socity_project_aspeed']).',';
					}
					if(!empty($settings['socity_project_speed'])){
						echo 'speed:'.esc_attr($settings['socity_project_speed']).',';
					}
					echo '
					responsive: [
						{
						breakpoint: 1024,
							settings: {
								slidesToShow: 2,
								slidesToScroll: 2,
								
							}
						},
						{
							breakpoint: 992,
							settings: {
								slidesToShow: 2,
								slidesToScroll: 2
							}
						},
						{
							breakpoint: 600,
							settings: {
								slidesToShow: 1,
								slidesToScroll: 1
							}
						},
						{
							breakpoint: 480,
							settings: {
								slidesToShow: 1,
								slidesToScroll: 1
							}
						}
					]
				});
			});
			</script>';
		}
		if($settings['socity_project_style'] == '2' ){
			$dynamic_num = rand(35245545, 541541745);
		?>
			<script>
				jQuery(window).ready(function($) {
				'use strict';
				jQuery('.rafo-project-shorting li').on('click',function(){
					jQuery('.rafo-project-shorting li').removeClass('active');
					jQuery(this).addClass('active');
					var selector = jQuery(this).attr('data-filter');
					jQuery('.projectlist-<?php echo esc_attr($dynamic_num) ?>').isotope({
						filter:selector,
					});
				});
				});
				jQuery(window).on('load',function($) {
					'use strict';
					jQuery(".projectlist-<?php echo esc_attr($dynamic_num) ?>").isotope();
				});
			</script>
			<?php
		}
		if($settings['socity_project_style'] == '1'){
			$socity_pro_type = 'project-style-one';
		}elseif($settings['socity_project_style'] == '2'){
			$socity_pro_type = 'project-style-two';
		}else{
			$socity_pro_type = 'project-style-three';
		}
		if($settings['socity_project_style'] == '3'){
			$col_num = '12';
		}elseif($settings['socity_project_style'] == '2'){
			$col_num = '4';
		}elseif($settings['socity_project_enable_sliders'] != 'yes'){
			$col_num = '12';
		}else{
			$col_num = '4';
		}
		?>
		<div class="project-boxs">
			<div class="project-box <?php echo esc_attr($socity_pro_type); ?>">
				<div class="project-haddings <?php if($settings['socity_project_style'] == '1') : ?>container<?php endif; ?>">
					<div class="row">
						<div class="col-12 col-sm-12 col-md-12 col-lg-<?php echo esc_attr($col_num) ?>">
							<div class="project-hadding">
								<span><?php echo esc_html($settings['socity_project_stitle']); ?></span>
								<h2><?php echo esc_html($settings['socity_project_hadding']); ?></h2>
							</div>
						</div>
						<?php if($settings['socity_project_style'] == '2' ) :
						$socity_prjects = get_terms( 'project_cat' ); if( !empty($socity_prjects) && ! is_wp_error( $socity_prjects ) ) :
						?>
						<div class="d-flex flex-wrap align-content-center justify-content-xl-end col-12 col-sm-12 col-md-12 col-lg-8">
							<div class="project-menu">
								<ul class="rafo-project-shorting">
									<li class="active" data-filter="*"><?php esc_html_e('all','socitycore'); ?></li>
									<?php foreach($socity_prjects as $socity_prject) : ?>
									<li data-filter=".<?php echo esc_attr($socity_prject->slug) ?>"><?php echo esc_html($socity_prject->name) ?></li>
									<?php endforeach; ?>
								</ul>
							</div>
						</div>
						<?php endif; endif; ?>
					</div>
				</div>
				<div class="project-contents arrow-nav">
					<div class="project-items row projectlist-<?php if(!empty($settings['socity_project_style'] == '2' )){echo esc_attr($dynamic_num);} ?>"  id="project-<?php echo esc_attr($dynamic_id); ?>">
						<?php  global $post;
						$paged = get_query_var('paged') ? get_query_var('paged') : 1;
						$p = new \WP_Query(array(
						'posts_per_page' => esc_attr($settings['socity_project_per_post']),
						'post_type' => 'project',
						'paged' => $paged
						));
						while($p->have_posts()) : $p->the_post();
							$socity_idd = get_the_ID();
							$socity_pro_meta = get_post_meta($socity_idd, 'socity_project_meta', true);
					    		$project_catagory = get_the_terms( get_the_ID(), 'project_cat' );
						if ( $project_catagory && ! is_wp_error( $project_catagory ) ) {
					   	 	$project_cat_list = array();
					    	foreach ( $project_catagory as $project_cat ) {
					        	$project_cat_list[] = $project_cat->slug;
					   	}
							$project_catshow = join( ", ", $project_cat_list );
						}else{
							$project_catshow = '';
					  	}
						?>
						<div class="item <?php if( ! empty($settings['socity_project_style'] !== "1" ) || !empty( $settings['socity_project_enable_sliders'] !== "yes" ) ) : ?>service-3 col-12 col-sm-<?php if( $settings['socity_project_style'] == '1' && $settings['socity_project_enable_sliders'] != 'yes' ) : ?>12<?php else : ?>6<?php endif; ?>  col-md-6 col-lg-4 col-xl-4 <?php echo esc_attr($project_catshow) ?><?php endif; ?>">
							<div class="project-signle">
								<?php
								if($settings['socity_project_style'] == '2' ){
									the_post_thumbnail('socity-project-image2');
								}else{
									the_post_thumbnail('socity-project-image');
								}
								?>
								<?php if(!empty( $settings['socity_project_style'] == '3' )) : ?>
								<div class="project-content">
									<div class="pro-left">
										<?php $socity_prjects = get_terms( 'project_cat' ); if( !empty($socity_prjects) && ! is_wp_error( $socity_prjects ) ) : ?>
										<ul>
										<?php foreach($socity_prjects as $socity_prject) : ?>
											<li><?php echo esc_html($socity_prject->name) ?></li>
										<?php endforeach; ?>
										</ul>
										<?php endif; ?>
										<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
									</div>
									<div class="pro-right">
										<a href="<?php the_permalink(); ?>" class="theme-button">
											<i class="flaticon-right-arrow"></i>
										</a>
									</div>
								</div>
								<?php else : ?>
								<div class="project-video">
									<a href="#" data-video-url="<?php echo esc_url($socity_pro_meta['socity_pro_video_link']); ?>" class="popUp" style="cursor: pointer;">
									<i aria-hidden="true" class="flaticon-play-button-1"></i></a>
								</div>
								<div class="project-title">
									<div class="theme-buttons">
										<a href="<?php the_permalink(); ?>" class="theme-button">
											<?php the_title(); ?><i class="flaticon-right-arrow"></i>
										</a>
									</div>
								</div>
								<?php endif; ?>
							</div>
						</div>
						<?php endwhile; wp_reset_postdata(); wp_reset_query();?>
					</div>
					<?php if($settings['socity_project_pagi'] == 'yes') : ?>
					<div class="cpaginations">
						<?php socity_paginate_nav( $p ); ?>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_project_Widget );
