<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_progress_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-progress';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Progress', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'progress' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_progress_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_progress_hadding',
			[
				'label' => esc_html__( 'Progress Hadding', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'You can check out our work. Are you ready for a better, more productive business?', 'socitycore' ),
				'placeholder' => esc_html__( 'Type your Progress Hadding here', 'socitycore' ),
			]
		);
		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'socity_progress_title',
			[
			    'label' => esc_html__( 'Progress Title', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Progress Title','socitycore'),
			]
		);
		$repeater->add_control(
			'socity_progress_num',
			[
			    'label' => esc_html__( 'Number', 'socitycore' ),
			    'type' => Controls_Manager::NUMBER,
			    'default' => 90,
			]
		);
		$repeater->add_control(
			'socity_progress_color',
			[
			    'label' => esc_html__( 'Opacity Color', 'socitycore' ),
			    'type' => Controls_Manager::COLOR,
			    'default' => '#3575de', 
			]
		);
		$repeater->add_control(
			'socity_progress_color2',
			[
			    'label' => esc_html__( 'Border Color', 'socitycore' ),
			    'type' => Controls_Manager::COLOR,
			    'default' => '#ffffff',
			]
		);
		$this->add_control(
			'socity_progress_items',
			[
				'label' => esc_html__( 'Progress Items', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'socity_progress_title' => esc_html__( 'Title', 'socitycore' ),
						'socity_progress_num' => 90,
						'socity_progress_color' => esc_html__( '+', 'socitycore' ),
					],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_progress_hadding_styles',
			[
				'label' => esc_html__( 'Hadding Style', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_progress_htypro',
			    'label' => __( 'Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .progress-hadding h2',
			]
		  );
		$this->add_control(
			'socity_progress_hadding_color',
			[
				'label' => esc_html__( 'Hadding Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .progress-hadding h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_progress_hadding_aline',
			[
			    'label' => __( 'Alignment', 'socitycore' ),
			    'type' => Controls_Manager::CHOOSE,
			    'options' => [
				  'left' => [
					'title' => esc_html__( 'Left', 'socitycore' ),
					'icon' => 'fa fa-align-left',
				  ],
				  'center' => [
					'title' => esc_html__( 'Center', 'socitycore' ),
					'icon' => 'fa fa-align-center',
				  ],
				  'right' => [
					'title' => esc_html__( 'Right', 'socitycore' ),
					'icon' => 'fa fa-align-right',
				  ]
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .progress-hadding h2' => 'text-align: {{VALUE}};',
			    ],
			    'separator' =>'before',
			]
		  );
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_progress_tab_section',
			[
			    'label' => esc_html__( 'Contents Style', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_progress_tabs');

        	$this->start_controls_tab( 'socity_progress_title_tabs',
			[
				'label' => esc_html__( 'Title', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_progress_ttle_typro',
			    'label' => __( 'Title Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .progress-title h3',
			]
		  );
		$this->add_control(
			'socity_progress_title_color',
			[
				'label' => esc_html__( 'Title Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .progress-title h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab( 'socity_progress_num_tabs',
			[
				'label' => esc_html__( 'Number', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_progress_num_typro',
			    'label' => __( 'Title Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .progress-bar div span',
			]
		  );
		$this->add_control(
			'socity_progress_num_color',
			[
				'label' => esc_html__( 'Number Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .progress-bar div span' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_progress_box_styles',
			[
				'label' => esc_html__( 'box Style', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_progress_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .progress-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);        
		$this->add_responsive_control(
			'socity_progress_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .progress-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		echo '
			<script>
			jQuery(document).ready(function($) {
				"use strict";
				$(".progress-bar").loading();
			});
			</script>';
		?>
		<div class="progress-box">
			<div class="porgree-hadding-section">
				<div class="progress-hadding">
					<h2><?php echo wp_kses_post(wpautop($settings['socity_progress_hadding'])); ?></h2>
				</div>
			</div>
			<div class="progress-items row">
			<?php foreach ( $settings['socity_progress_items'] as $socity_progress_item  ) : ?>
				<div class="col-sm-6 col-md-3">
				<div class="item">
					<div class="progress-bar position" data-percent="<?php echo esc_attr($socity_progress_item['socity_progress_num']) ?>" data-duration="1000" data-color="<?php echo esc_html($socity_progress_item['socity_progress_color']); ?>,<?php echo esc_html($socity_progress_item['socity_progress_color2']); ?>"></div>
					<div class="progress-title">
						<h3><?php echo esc_html($socity_progress_item['socity_progress_title']); ?></h3>
					</div>
				</div>
				</div>
			<?php endforeach; ?>
			</div>
		</div>
	
		<?php
		
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_progress_Widget );