<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_counter_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-counter';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Counter', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'counter' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_counter_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_counter_title',
			[
			    'label' => esc_html__( 'Title', 'socitycore' ),
			    'type'    => Controls_Manager::TEXT,
			    'default' => esc_html__('Counter Title','socitycore'),
			]
		);
		$this->add_control(
			'socity_counter_num',
			[
				'label' => esc_html__( 'Number', 'socitycore' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 50,
			]
		);
		$this->add_control(
			'socity_counter_symbel',
			[
			    'label' => esc_html__( 'Symble', 'socitycore' ),
			    'type'     => Controls_Manager::TEXT,
			    'default'  => esc_html__('+','socitycore'),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_counter_styles',
			[
				'label' => esc_html__( 'Style', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_counter_box_alignment',
			[
				'label' => esc_html__( 'Box Alignment', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'socitycore' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'socitycore' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'socitycore' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .counter-box' => 'text-align: {{VALUE}};',
				],
				'default' => 'center',
				'toggle' => true,
			]
		);
		$this->add_responsive_control(
			'socity_counter_box_padding',
			[
			    'label' => esc_html__( 'Box Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '120px',
				  'right' => '0',
				  'bottom' => '120px',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .counter-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->add_responsive_control(
			'socity_counter_box_margin',
			[
			    'label' => esc_html__( 'Box Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .counter-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->add_control(
			'coline0',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_counter_number_color',
			[
				'label' => esc_html__( 'Number Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .counter-count.timer' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Title Typography', 'socitycore' ),
			    	'name' => 'socity_counter_number_typo',
			    	'selector' => '{{WRAPPER}} .counter-count.timer',
			]
		);  
		$this->add_control(
			'coline',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_counter_symble_color',
			[
				'label' => esc_html__( 'Title Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .counter-num label' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_counter_symble_typo',
			    'label' => esc_html__( 'Symble Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .counter-num label',
			]
		); 
		$this->add_control(
			'coline1',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_counter_title_color',
			[
				'label' => esc_html__( 'Symble Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .counter-content.couner-time h4' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_counter_title_typo',
			    'label' => esc_html__( 'Symble Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .counter-content.couner-time h4',
			]
		); 
		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		echo '
			<script>
			jQuery(document).ready(function($) {
				 "use strict";
				$(".timer").countTo();
				$(".couner-time").appear(function() {
				    $(".timer").countTo();
				}, {
				    accY: -200
				});
			});
			</script>
		';
		?>
		<div class="counter-box">
			<div class="counter-content couner-time">
				<div class="counter-num">
				<div class="counter-count timer" data-to="<?php echo esc_attr($settings['socity_counter_num']); ?>" data-speed="5000">
			<?php echo esc_html($settings['socity_counter_num']); ?>
				</div>
				<?php if(!empty($settings['socity_counter_symbel'])) : ?>
				<label><?php echo esc_html($settings['socity_counter_symbel']) ?></label>
			<?php endif; ?>
				</div>
				<?php if(!empty($settings['socity_counter_title'])){
					echo '<h4>'.esc_html($settings['socity_counter_title']).'</h4>';
				}?>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_counter_Widget );