<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_about_video_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-about-video';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity About Video', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'about-video' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_about_contens',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_about_video_image',
			[
			    'label' => esc_html__( 'Image', 'socitycore' ),
			    'type' => Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'socity_about_video_logo',
			[
			    'label' => esc_html__( 'Logo Image', 'socitycore' ),
			    'type' => Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'socity_about_video_icon',
			[
				'label' => esc_html__( 'ICONS', 'socitycore' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'flaticon-play-button-1',
					'library' => 'regular',
				],
			]
		);
		$this->add_control(
			'socity_about_video_link',
			[
			    'label'         => esc_html__( 'video Link', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('https://www.youtube.com/watch?v=u8Egk_j0EbY','socitycore'),
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_about_video_styles',
			[
				'label' => esc_html__( 'Style', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'socity_about_video_tabs'
		);
		$this->start_controls_tab(
			'socity_about_video_ntab',
			[
				'label' => esc_html__( 'Normal', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
			    'name' => 'socity_about_video_bg',
			    'label' => esc_html__( 'Background', 'socitycore' ),
			    'types' => [ 'classic', 'gradient' ],
			    'selector' => '{{WRAPPER}} .socity-about-v-bg',
			]
		);
		$this->add_control(
			'socity_about_v_con_color',
			[
				'label' => esc_html__( 'Icon Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-video-icon i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_about_v_con_size',
			[
				'label' => esc_html__( 'Icon Size', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .about-video-icon i:before' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_about_vmargin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .socity-about-v-bg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);        
		$this->add_responsive_control(
			'socity_about_vpadding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .socity-about-v-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);  
		$this->end_controls_tab();
		$this->start_controls_tab(
			'socity_about_video_htab',
			[
				'label' => esc_html__( 'Hover', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
			    'name' => 'socity_about_video_hbg',
			    'label' => esc_html__( 'Hover Background', 'socitycore' ),
			    'types' => [ 'classic', 'gradient' ],
			    'selector' => '{{WRAPPER}} .socity-about-video-img:hover .socity-about-v-bg',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'socity_about_video_shadow',
				'label' => __( 'Box Shadow', 'socitycore' ),
				'selector' => '{{WRAPPER}} .socity-about-video-img:hover .socity-about-v-bg',
			]
		);
		$this->add_control(
			'socity_about_v_con_hcolor',
			[
				'label' => esc_html__( 'Icon Hover Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-video-icon:hover i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_about_vh_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .about-video-box:hover .socity-about-v-bg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);        
		$this->add_responsive_control(
			'socity_about_vh_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .about-video-box:hover .socity-about-v-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_about_video_logo_styles',
			[
				'label' => esc_html__( 'Logo', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_about_v_logo_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .socity-about-v-logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);        
		$this->add_responsive_control(
			'socity_about_v_logo_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .socity-about-v-logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);  
		$this->end_controls_section();

	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if(!empty($settings['socity_about_video_link'] )){
			echo '
			<script>
			jQuery(document).ready(function($) {
				"use strict";
				$(function() {
					$(".popUp").videoPopup( {
					    autoplay: 1, controlsColor: "white", 
					    showVideoInformations: 0, 
					    width: 1000, 
					    customOptions: {
						  rel: 0, 
						  end: 60
					    }
					});
				});
			});
			</script>';
            }
		?>
		<div class="about-video-boxs">
			<div class="about-video-box">
				<div class="socity-about-video-img">
					<div class="socity-av-logo">
					<?php echo wp_get_attachment_image( $settings['socity_about_video_logo']['id'], 'large' ); ?>
					</div>
					<?php echo wp_get_attachment_image( $settings['socity_about_video_image']['id'], 'full' ); ?>
					<div class="about-video-icon">
	<a href="#" <?php if(!empty($settings['socity_about_video_link'])) : ?> data-video-url="<?php echo esc_url($settings['socity_about_video_link']) ?>" class="popUp" <?php endif; ?> >
							<?php \Elementor\Icons_Manager::render_icon( $settings['socity_about_video_icon'], [ 'aria-hidden' => 'true' ] ); ?>
						</a>
					</div>
					<div class="socity-about-v-bg"></div>
				</div>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_about_video_Widget );