<?php 
if ( !function_exists( 'socity_google_fonts_url' ) ) {

    function socity_google_fonts_url() {
        $socity_fonts_url = '';
        $socity_fonts     = array();
        $socity_subsets   = 'latin-ext';
        $socity_fonts[] 	= 'Open+Sans:300,400,600,600i,700,700i,800,800i';
        $socity_fonts[] 	= 'Poppins:200,300,400,500,600,700,800,900';

        if ( $socity_fonts ) {
            $socity_fonts_url = add_query_arg( array(
                'family' =>  implode( '|', $socity_fonts ),
                'subset' =>  $socity_subsets,
            ), '//fonts.googleapis.com/css' );
        }
        return esc_url_raw($socity_fonts_url);
    }
}

function socity_assets() {
	$socity_css_files = array(
		'bootstrap'       => SOCITY_ASSETS_DIR . 'bootstrap/bootstrap-min.css',
    'animate'      	=> SOCITY_ASSETS_DIR . 'animations/animate.css',
    'owl-carousel'    => SOCITY_ASSETS_DIR . 'owlcarousel/owl-carousel.css',
    'font-awesome' 	=> SOCITY_ASSETS_DIR . 'css/font-awesome-min.css',
    'flaticon' 	      => SOCITY_ASSETS_DIR . 'css/flaticon.css',
    'sm-core'       	=> SOCITY_ASSETS_DIR . 'menu/sm-core.css',
		'sm-simple'       => SOCITY_ASSETS_DIR . 'menu/sm-simple.css',
    'slick'           => SOCITY_ASSETS_DIR . 'slick/slick.css',
    'slick-theme'      => SOCITY_ASSETS_DIR . 'slick/slick-theme.css',
    'socity-default'    => SOCITY_ASSETS_DIR . 'css/default.css',
    'socity-typrography'    => SOCITY_ASSETS_DIR . 'css/typrography.css',
    'flag-icon'    => SOCITY_ASSETS_DIR . 'css/flag-icon.min.css',
    'magnific-popup-css'    => SOCITY_ASSETS_DIR . 'gallery/magnific-popup.css',
    'socity-theme'      => SOCITY_ASSETS_DIR . 'css/theme.css',
		'socity-responsive' => SOCITY_ASSETS_DIR . 'css/responsive.css',
	);
	foreach ( $socity_css_files as $socity_handle => $socity_css_file ) {
		wp_enqueue_style( $socity_handle, $socity_css_file, null,SOCITY_VERSION );
      }
      if( ! defined('CS_ACTIVE_FRAMEWORK') && ! function_exists('cs_get_option') ){
	 // Add google fonts, used in the main stylesheet.
      wp_enqueue_style( 'socity-fonts', socity_google_fonts_url(), array(), null );
      }
     
      
      wp_enqueue_style( 'socity-style', get_stylesheet_uri(), null,SOCITY_VERSION );
      wp_style_add_data( 'socity-style', 'rtl', 'replace' );
      
	// Add WordPress Default Masonry, Used for attach grid.
      wp_enqueue_script('jquery-masonry');
	$socity_js_files = array(
		'modernizr'         => array( 'src' => SOCITY_ASSETS_DIR . 'vendor/modernizr.js','dep' => array( 'jquery' )),
		'popper-min'        => array( 'src' => SOCITY_ASSETS_DIR . 'bootstrap/popper-min.js','dep' => array( 'jquery' )),
    'bootstrap'         => array( 'src' => SOCITY_ASSETS_DIR . 'bootstrap/bootstrap-min.js','dep' => array( 'jquery' )),
    'smartmenus'   	    => array( 'src' => SOCITY_ASSETS_DIR . 'menu/smartmenus.js','dep' => array( 'jquery' )),
    'owl-carousel'      => array( 'src' => SOCITY_ASSETS_DIR . 'owlcarousel/owl-carousel-min.js', 'dep' => array( 'jquery' ) ),
    'slick-min'         => array( 'src' => SOCITY_ASSETS_DIR .   'slick/slick-min.js', 'dep' => array( 'jquery' ) ),
    'magnific-popup'    => array( 'src' => SOCITY_ASSETS_DIR .   'gallery/jquery-magnific-popup-min.js', 'dep' => array( 'jquery' ) ),
    'socity-woojs'      => array( 'src' => SOCITY_ASSETS_DIR .   'gallery/woojs.js', 'dep' => array( 'jquery' ) ),
		'socity-navigation' => array( 'src' => SOCITY_ASSETS_DIR . 'js/navigation.js', 'dep' => array( 'jquery' ) ),
		'socity-skip-link-focus-fix'  => array( 'src' => SOCITY_ASSETS_DIR . 'js/skip-link-focus-fix.js', 'dep' => array( 'jquery' ) ),
		'socity-main'       => array( 'src' => SOCITY_ASSETS_DIR . 'js/main.js', 'dep' => array( 'jquery' ) ),
      );
      
	foreach ( $socity_js_files as $socity_handle => $socity_js_file ) {
		wp_enqueue_script( $socity_handle, $socity_js_file['src'], $socity_js_file['dep'], SOCITY_VERSION , true );
      }
	// Add comment reply script.
      if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
            wp_enqueue_script( 'comment-reply' );
      }

      if( is_cs_framework_active() ) {
		$socity_body_end_script 	= cs_get_option('socity_body_end_script');
		$socity_head_script 		= cs_get_option('socity_head_script');
		$socity_custom_css_script = cs_get_option('socity_custom_css_script');
		wp_add_inline_script('socity-main', $socity_body_end_script);
		wp_add_inline_script('jquery-migrate', $socity_head_script);
		wp_add_inline_style('socity-theme', $socity_custom_css_script);
	}
	
}
add_action( 'wp_enqueue_scripts', 'socity_assets' );