<?php 

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function socity_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'socity' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'socity' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widtet-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer', 'socity' ),
		'id'            => 'socity-footer',
		'description'   => esc_html__( 'Add widgets here.', 'socity' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s masonry-item col-lg-3 col-md-6 col-sm-6 col-12">
		<div class="socity-ft-content">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h2 class="widtet-title"><span>',
		'after_title'   => '</span></h2>',
	) );

	if ( class_exists( 'WooCommerce' ) ) {
	register_sidebar( array(
		'name'          => esc_html__( 'Shop Widget', 'socity' ),
		'id'            => 'tuchno-shop',
		'description'   => esc_html__( 'Add widgets here.', 'socity' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widtet-title"><span>',
		'after_title'   => '</span></h2>',
	) );}
}
add_action( 'widgets_init', 'socity_widgets_init' );