<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package socity 
 */
if( is_cs_framework_active() ) {
	$socity_ft_copyright = cs_get_option('socity_ft_copyright');
	$socity_ft_copyright_kses =array(
    'a' => array(
	  'href' => array(),
	  'class' => array()
    ),
    'br' => array(),
    'em' => array(),
    'strong' => array(),
    'span' => array(),
);
}?>
</div><!-- #content -->

	<footer id="colophon" class="site-footer">
		<?php if( is_active_sidebar( 'socity-footer' )) : ?>
		<div class="footer-top socity-footer-widgets">
			<div class="container">
				<div class="row socity-ftw-box masonrys">
				<?php dynamic_sidebar('socity-footer'); ?>
				</div>
			</div>
		</div>
		<?php endif; ?>
		<div class="footer-copyright-area">
			<div class="container">
				<div class="row">
					<div class="col-md-6 d-flex flex-wrap align-content-center">
						<div class="copyright">
						<p>
						<?php if(!empty($socity_ft_copyright)){
							echo wp_kses(wpautop($socity_ft_copyright), $socity_ft_copyright_kses);
						}else{
							esc_html_e('Copyright 2020 Themepul All Rights Reserved.','socity');
						} ?>
						</p>
						</div>
					</div>
					<div class="col-md-6 d-flex justify-content-end">
						<div class="footer-menu">
							<?php
								if ( has_nav_menu( 'footer-menu' ) ) {
									wp_nav_menu( array(
										'container_id'=>'footermenu',
										'menu_class'=>'navbar-nav mr-auto ml-auto sm sm-simple',
										'menu_id'=>'footer-menu',
										'theme_location'=>'footer-menu',
										'echo'            => true,
										'fallback_cb'     => false,
									));
								}
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</footer><!-- #colophon -->
</div><!-- #page -->
<div class="to-top" id="back-top"><i class="fa fa-angle-up"></i></div>
<?php wp_footer(); ?>

</body>
</html>
