<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package socity
 */
	if (defined('CS_ACTIVE_FRAMEWORK') && function_exists('cs_get_option')) {
		$socity_pfa_meta = get_post_meta( $post->ID, 'socity_pfa_meta', true );
		$code = 'iframe';
	}
?>
<div id="post-<?php the_ID(); ?>" <?php post_class('post-single'); ?>>
	<?php if(!empty($socity_pfa_meta['socity_pfa_link'])) : ?>
	<div class="post-audio">
        <<?php echo esc_attr($code); ?> width="100%" height="100%" scrolling="no" frameborder="no" allow="autoplay" src="<?php echo esc_url($socity_pfa_meta['socity_pfa_link']) ?>"></<?php echo esc_attr($code); ?>>
    </div>
	<?php else : ?>
	<div class="socity-bimg">
		<?php socity_post_thumbnail(); ?>		
	</div>
	<?php endif; ?>
	<?php get_template_part('template-parts/content','summery'); ?>
</div>