<?php
class socity_Recent_Posts_Widget extends WP_Widget {
// Main constructor
	public function __construct() {

		$widget_id       = 'socity_recent_post';
		$widget_title    = esc_html__( 'socity Recent Post With Thumbnails', 'socitycore' );
		$widget_settings = array(
			'customize_selective_refresh' => true,
			'classname'                   => 'socity_Recent_Posts_Widget',
			'description'                 => esc_html__( 'Display Recent Posts with thumbnails', 'socitycore' )
		);

		parent::__construct( $widget_id, $widget_title, $widget_settings );
	}
// The widget form (for the backend )
	public function form( $instance ) {
// Set widget defaults
		$defaults = array(
			'title' => esc_html__( 'Recent Posts', 'socitycore' ),
			'socity_count' => 3,
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		<!-- Title -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Widget Title', 'socitycore' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>"/>
		</p>
		<!-- Posts socity_count -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'socity_count' ) ); ?>"><?php esc_html_e( 'Posts Count:', 'socitycore' ); ?></label>
			<input type="number" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'socity_count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'socity_count' ) ); ?>" value="<?php echo esc_attr( $instance['socity_count'] ); ?>"/>
		</p>
		<?php
	}
// Update widget settings
	public function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = isset( $new_instance['title'] ) ? wp_strip_all_tags( $new_instance['title'] ) : '';
		$instance['socity_count'] = isset( $new_instance['socity_count'] ) ? wp_strip_all_tags( $new_instance['socity_count'] ) : '';
		return $instance;
	}
// Display the widget
	public function widget( $args, $instance ) {
		extract( $args );
		// Check the widget options
		$title = isset( $instance['title'] ) ? apply_filters( 'widget_title', $instance['title'] ) : esc_html_e('Instagram Feed','socitycore');
		$socity_count = isset( $instance['socity_count'] ) ? $instance['socity_count'] : 3 ;
		echo wp_kses_post($before_widget);
		if ( ! empty($title) ) :
			echo wp_kses_post( $before_title ) . esc_html( $title ) . wp_kses_post( $after_title );
		endif; ?>
		<div class="widget-recent-posts">
			<?php
			$socity_sticky = get_option( 'sticky_posts' );
			$socity_query   = new WP_Query( array(
				'posts_per_page'      => $socity_count,
				'ignore_sticky_posts' => 1,
				'post__not_in'        => $socity_sticky,
			) );
			?>
			<?php if ( $socity_query ->have_posts() ) : while ( $socity_query ->have_posts() ) : $socity_query ->the_post(); ?>
				<div class="socity-recent-post-single">
					<?php if ( has_post_thumbnail() ) { ?>
					<div class="socity-widget-recent-post-img">
						<a href="<?php esc_url(the_permalink()); ?>"><img src="<?php esc_url(the_post_thumbnail_url()); ?>" alt="<?php the_title_attribute(); ?>" class="widget-posts-img"></a>
					</div>
					<?php } ?>
					<div class="socity-widget-posts-descr">
						<h3 class="socity-widget-post-title post-title">
						<a href="<?php esc_url( the_permalink() ); ?>" class="title"><?php echo esc_html( get_the_title(), 6 ); ?></a>
						</h3>
						<div class="date"><?php echo esc_html( get_the_date() ); ?></div>
					</div>
				</div>
			<?php endwhile; endif; ?>
		</div>
		<?php echo wp_kses_post($after_widget);
	}
}
// Register Widget
function socity_register_recent_posts_widget() {
	register_widget( 'socity_Recent_Posts_Widget' );
}
add_action( 'widgets_init', 'socity_register_recent_posts_widget' );