<?php 
// Adds widget: socity info Widget
class socityinfowidget_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'socityinfowidget_widget',
			esc_html__( 'socity info Widget', 'socitycore' )
		);
		add_action( 'admin_footer', array( $this, 'media_fields' ) );
		add_action( 'customize_controls_print_footer_scripts', array( $this, 'media_fields' ) );
	}

	private $widget_fields = array(
		array(
			'label' => 'Info Logo',
			'id' => 'socity_info_logo',
			'type' => 'media',
		),
		array(
			'label' => 'info description',
			'id' => 'socity_info_dec',
			'type' => 'textarea',
		),
		array(
			'label' => 'info Apps Link',
			'id' => 'socity_info_apps_link',
			'type' => 'text',
		),
	);

	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post($args['before_title']) . apply_filters( 'widget_title', $instance['title'] ) . wp_kses_post($args['after_title']);
		}

            ?>
            <div class="ft-info-section">
            	<?php if(!empty($socity_info_logo)) : ?>
                  <div class="ft-info-logo">
                        <?php $socity_info_logo = wp_get_attachment_image_src( $instance['socity_info_logo'] ); ?>
                       <img src="<?php echo esc_url($socity_info_logo[0]); ?>" alt="<?php echo esc_attr($instance['title']); ?>">
                  </div>
              	<?php endif; ?>
                  <div class="ft-info-dec">
                        <p><?php echo esc_html($instance['socity_info_dec']); ?></p>
                  </div>
                  <div class="tf-info-btn">
                        <a href="<?php echo esc_url($instance['socity_info_apps_link']); ?>"></a>
                  </div>
            </div>
            <?php 
		
		echo wp_kses_post($args['after_widget']);
	}

	public function media_fields() {
		?><script>
			jQuery(document).ready(function($){
				if ( typeof wp.media !== 'undefined' ) {
					var _custom_media = true,
					_orig_send_attachment = wp.media.editor.send.attachment;
					$(document).on('click','.custommedia',function(e) {
						var send_attachment_bkp = wp.media.editor.send.attachment;
						var button = $(this);
						var id = button.attr('id');
						_custom_media = true;
							wp.media.editor.send.attachment = function(props, attachment){
							if ( _custom_media ) {
								$('input#'+id).val(attachment.id);
								$('span#preview'+id).css('background-image', 'url('+attachment.url+')');
								$('input#'+id).trigger('change');
							} else {
								return _orig_send_attachment.apply( this, [props, attachment] );
							};
						}
						wp.media.editor.open(button);
						return false;
					});
					$('.add_media').on('click', function(){
						_custom_media = false;
					});
					$(document).on('click', '.remove-media', function() {
						var parent = $(this).parents('p');
						parent.find('input[type="media"]').val('').trigger('change');
						parent.find('span').css('background-image', 'url()');
					});
				}
			});
		</script><?php
	}

	public function field_generator( $instance ) {
		foreach ( $this->widget_fields as $widget_field ) {
			$default = '';
			if ( isset($widget_field['default']) ) {
				$default = $widget_field['default'];
			}
			$widget_value = ! empty( $instance[$widget_field['id']] ) ? $instance[$widget_field['id']] : esc_html__( $default, 'socitycore' );
			switch ( $widget_field['type'] ) {
				case 'media':
					$media_url = '';
					if ($widget_value) {
						$media_url = wp_get_attachment_url($widget_value);
                              }
                              
                              ?>
                              <p>
                              <label for="<?php echo esc_attr( $this->get_field_id( $widget_field['id'] ) ); ?>"><?php echo esc_attr( $widget_field['label'], 'socitycore' ) ?>:</label>
                              <input style="display:none;" class="widefat" id="<?php echo esc_attr( $this->get_field_id( $widget_field['id'] ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( $widget_field['id'] ) ); ?>" type="<?php echo esc_attr($widget_field['type']) ?>" value="<?php echo esc_attr($widget_value); ?>">
                              <span id="preview<?php echo esc_attr( $this->get_field_id( $widget_field['id'] ) ) ?>" style="margin-right:10px;border:2px solid #eee;display:block;width: 100px;height:100px;background-image:url(<?php esc_url($media_url) ?>);background-size:contain;background-repeat:no-repeat;"></span>
                              <button id="<?php echo esc_attr($this->get_field_id( $widget_field['id'] )); ?>" class="button select-media custommedia"><?php esc_html_e('Add Media','socitycore'); ?></button>
                              <input style="width: 19%;" class="button remove-media" id="buttonremove" name="buttonremove" type="button" value="Clear" />
                              </p>
                              <?php 

					break;
                        case 'textarea':
                              ?>
                              <p>
                              <label for="<?php echo esc_attr( $this->get_field_id( $widget_field['id'] ) ); ?>"><?php echo esc_attr( $widget_field['label'], 'socitycore' ) ?>:</label>
                              <textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( $widget_field['id'] ) ) ?>" name="<?php echo esc_attr( $this->get_field_name( $widget_field['id'] ) ) ?>" rows="6" cols="6" value="<?php echo esc_attr( $widget_value ) ?>"><?php echo esc_html($widget_value); ?></textarea>
                              </p>
                              <?php 
					break;
                        default:
                        ?>
                        <p>
                        <label for="<?php echo esc_attr( $this->get_field_id( $widget_field['id'] ) ); ?>"><?php echo esc_attr( $widget_field['label'], 'socitycore' ) ?>:</label>
                        <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( $widget_field['id'] ) ) ?>" name="<?php echo esc_attr( $this->get_field_name( $widget_field['id'] ) ) ?>" type="<?php echo esc_attr($widget_field['type']) ?>" value="<?php echo esc_attr(esc_attr( $widget_value )) ?>">
                        </p>
                        <?php 
			}
		}
	}

	public function form( $instance ) {
		$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( '', 'socitycore' );
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'socitycore' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<?php
		$this->field_generator( $instance );
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		foreach ( $this->widget_fields as $widget_field ) {
			switch ( $widget_field['type'] ) {
				default:
					$instance[$widget_field['id']] = ( ! empty( $new_instance[$widget_field['id']] ) ) ? strip_tags( $new_instance[$widget_field['id']] ) : '';
			}
		}
		return $instance;
	}
}

function register_socityinfowidget_widget() {
	register_widget( 'socityinfowidget_Widget' );
}
add_action( 'widgets_init', 'register_socityinfowidget_widget' );