<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_support_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-support';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Support', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'support' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_support_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_support_title',
			[
			    'label' => esc_html__( 'Title', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Still need help for any problem?','socitycore'),
			]
		);
		$this->add_control(
			'socity_support_dec',
			[
			    'label' => esc_html__( 'Hadding', 'socitycore' ),
			    'type' => Controls_Manager::WYSIWYG,
			    'default' => esc_html__( 'Check out our In-App Help, Blog, and Youtube Channel. You can also email our support team at support@avso.com.','socitycore' )
			]
		);
		$this->add_control(
			'socity_support_btn_enable',
			[
				'label' => esc_html__( 'Enable Buttons', 'socitycore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'socitycore' ),
				'label_off' => esc_html__( 'Hide', 'socitycore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'socity_support_buttons_links',
			[
				'label' => esc_html__( 'Select Link', 'socitycore' ),
				'type'  => Controls_Manager::SELECT,
				'default'	=> 'extranal',
				'options' => [
					'extranal' => esc_html__( 'Extranal', 'socitycore' ),
					'page' =>  esc_html__( 'Page', 'socitycore' ),
				],
				'condition' => [
					'socity_support_btn_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'socity_support_buttons_link_extralnal',
			[
				'label' => esc_html__( 'Extranal Link', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'socity_support_buttons_links' => 'extranal',
					'socity_support_btn_enable' => 'yes',
				],
				'placeholder' => esc_html__( 'Add Extranal Link', 'socitycore' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'socity_support_buttons_page_link',
			[
				'label' => esc_html__( 'Page Link', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'options' => socity_page_list(),
				'condition' => [
					'socity_support_buttons_links' => 'page',
					'socity_support_btn_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'socity_support_buttons_link_test',
			[
			    'label' => esc_html__( 'Button Link Text', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Get free more','socitycore'),
			    'condition' => [
					'socity_support_btn_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'socity_support_button_new_tab',
			[
			    'label'         => esc_html__( 'Open New Tab ? ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'Yes', 'socitycore' ),
			    'label_off'     => esc_html__( 'No', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'no',
			    'condition' => [
					'socity_support_btn_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'socity_support_gb_icon',
			[
				'label' => esc_html__( 'Background Icon', 'socitycore' ),
				'type' => Controls_Manager::ICON,
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_support_styles',
			[
				'label' => esc_html__( 'box', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_support_box_tabs');

        	$this->start_controls_tab( 'socity_support_box_tab',
			[
				'label' => esc_html__( 'Normal', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_support_box_bg',
				'label' => esc_html__( 'Background color', 'socitycore' ),
				'types' => [ 'classic' ],
				'default' => '#0b5be0',
				'selector' => '{{WRAPPER}} .support-boxs',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'socity_support_box_border',
				'label' => esc_html__( 'Border', 'socitycore' ),
				'selector' => '{{WRAPPER}} .support-boxs',
			]
		);
		$this->add_responsive_control(
			'socity_support_box_border_radius',
			[
			    'label' => esc_html__( 'Border Radius', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-boxs' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->add_responsive_control(
			'socity_support_box_alignment',
			[
				'label' => esc_html__( 'Alignment', 'socitycore' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'socitycore' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'socitycore' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'socitycore' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .support-boxs' => 'text-align: {{VALUE}};',
				],
				'default' => 'center',
				'toggle' => true,
			]
		);
		$this->add_responsive_control(
			'socity_support_box_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '50',
				  'right' => '50',
				  'bottom' => '50',
				  'left' => '50',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-boxs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->add_responsive_control(
			'socity_support_box_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-boxs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->end_controls_tab();

		$this->start_controls_tab( 'socity_support_box_htab',
			[
				'label' => esc_html__( 'Hover', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_support_box_hbg',
				'label' => esc_html__( 'Background color', 'socitycore' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .support-boxs:hover',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'socity_support_box_hborder',
				'label' => esc_html__( 'Border', 'socitycore' ),
				'selector' => '{{WRAPPER}} .support-boxs:hover',
			]
		);
		$this->add_responsive_control(
			'socity_support_box_border_hradius',
			[
			    'label' => esc_html__( 'Border Radius', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-boxs:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_support_icon_style',
			[
				'label' => esc_html__( 'Icon', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_support_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'selectors' => [
					'{{WRAPPER}} .support-bg-icon i:before' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_support_icon_roted',
			[
				'label' => esc_html__( 'Icon rotate', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'deg' ],
				'range' => [
					'deg' => [
						'min' => -190,
						'max' => 190,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'deg',
					'size' => 45,
				],
				'selectors' => [
					'{{WRAPPER}} .support-bg-icon' => 'transform:rotate({{SIZE}}{{UNIT}}) ;',
				],
			]
		);
		$this->add_responsive_control(
			'socity_support_icon_top',
			[
				'label' => esc_html__( 'Icon Position', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px','%' ],
				'range' => [
					'px' => [
						'min' => -190,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => -190,
						'max' => 300,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .support-bg-icon' => 'top:{{SIZE}}{{UNIT}} ;',
				],
			]
		);
		$this->add_control(
			'socity_support_icon_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .support-bg-icon i:before' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_responsive_control(
			'socity_support_icon_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-bg-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->add_responsive_control(
			'socity_support_icon_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-bg-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_support_title_styles',
			[
				'label' => esc_html__( 'Title', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_support_title_tabs');

        	$this->start_controls_tab( 'socity_support_title_tab',
			[
				'label' => esc_html__( 'Normal', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_support_title_color',
			[
				'label' => esc_html__( 'Title Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' =>'#ffffff',
				'selectors' => [
					'{{WRAPPER}} .support-boxs h2' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_support_title_typo',
			    'selector' => '{{WRAPPER}} .support-boxs h2',
			]
		);  
		$this->end_controls_tab();

		$this->start_controls_tab( 'socity_support_title_htab',
			[
				'label' => esc_html__( 'Hover', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_support_title_hcolor',
			[
				'label' => esc_html__( 'Title Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .support-boxs:hover h2' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_support_dec_styles',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_support_dec_tabs');

        	$this->start_controls_tab( 'socity_support_dec_tab',
			[
				'label' => esc_html__( 'Normal', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_support_dec_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' =>'#ffffff',
				'selectors' => [
					'{{WRAPPER}} .support-dec' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_support_dec_typo',
			    'selector' => '{{WRAPPER}} .support-dec',
			]
		);  
		$this->add_responsive_control(
			'socity_support_dec_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '10',
				  'right' => '0',
				  'bottom' => '10',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-dec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->add_responsive_control(
			'socity_support_dec_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-dec' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->end_controls_tab();

		$this->start_controls_tab( 'socity_support_dec_htab',
			[
				'label' => esc_html__( 'Hover', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_support_dec_hcolor',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' =>'#ffffff',
				'selectors' => [
					'{{WRAPPER}} .support-boxs:hover .support-dec' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_support_btn_styles',
			[
				'label' => esc_html__( 'Button', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_support_btn_tabs');

        	$this->start_controls_tab( 'socity_support_btn_tab',
			[
				'label' => esc_html__( 'Normal', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_support_btn_typo',
			    'selector' => '{{WRAPPER}} .support-btn .theme-button',
			]
		);  
		$this->add_control(
			'socity_support_btn_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' =>'#ffffff',
				'selectors' => [
					'{{WRAPPER}} .support-btn .theme-button' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_support_bg',
				'label' => esc_html__( 'border Hover', 'socitycore' ),
				'types' => [ 'classic' ],
				'default'=>'#1d67e2',
				'selector' => '{{WRAPPER}} .support-btn .theme-button',
			]
		);
		$this->add_responsive_control(
			'socity_support_btn_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-btn .theme-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->add_responsive_control(
			'socity_support_btn_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .support-btn .theme-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->end_controls_tab();

		$this->start_controls_tab( 'socity_support_btn_htab',
			[
				'label' => esc_html__( 'Hover', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_support_btn_hcolor',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' =>'#000000',
				'selectors' => [
					'{{WRAPPER}} .support-boxs .theme-button:hover' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_support_hbg',
				'label' => esc_html__( 'border Hover', 'socitycore' ),
				'types' => [ 'classic' ],
				'default' => '#ffffff',
				'selector' => '{{WRAPPER}} .support-boxs .theme-button:hover',
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();

		
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if( $settings['socity_support_buttons_page_link'] == 'page' ){
			$socity_title_btn_page = get_page_link( $settings['socity_support_buttons_page_link'] );
		}else{
			$socity_title_btn_page =  $settings['socity_support_buttons_link_extralnal'];
		}
		?>
		<div class="support-boxs">
			<div class="support-box">
				<?php if(!empty($settings['socity_support_gb_icon'])){
					echo '<div class="support-bg-icon"><i class="'.esc_attr($settings['socity_support_gb_icon']).'"></i></div>';
				}
				?>
				<?php if(!empty($settings['socity_support_title'])){
					echo '<h2>'.esc_html($settings['socity_support_title']).'</h2>';
				}?>
				<div class="support-dec">
				<?php echo wp_kses_post(wpautop($settings['socity_support_dec'])); ?>
				</div>
				<?php if(!empty($settings['socity_support_btn_enable'])) : ?>
				<div class="support-btn">
					<div class="theme-buttons">
						<a href="<?php echo esc_url($socity_title_btn_page); ?>" <?php if(!empty($settings['socity_support_button_new_tab'])) : ?>target="_blank"<?php endif; ?> class="theme-button">
							<?php echo esc_html($settings['socity_support_buttons_link_test']); ?><i class="flaticon-right-arrow"></i>
						</a>
					</div>
				</div>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_support_Widget );