<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_service_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-service';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Service', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'service' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_service_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_service_select',
			[
			    'label' => esc_html__('Choose Style','socitycore'),
			    'type' =>Controls_Manager::SELECT,
			    'options' => [
					'1'  	=> esc_html__( 'Style One', 'socitycore' ),
					'2' 	=> esc_html__( 'Style Two', 'socitycore' ),
					'3' 	=> esc_html__( 'Style Three', 'socitycore' ),
			    	],
			    'default' => '1',
			]
		  );
		  $this->add_control(
			'service_icons_type',
			[
			    'label' => esc_html__('Service Icon Type','socitycore'),
			    'type' =>Controls_Manager::CHOOSE,
			    'options' =>[
				  'img' =>[
					'title' =>esc_html__('Image','socitycore'),
					'icon' =>'fa fa-picture-o',
				  ],
				  'icon' =>[
					'title' =>esc_html__('Icon','socitycore'),
					'icon' =>'fa fa-info',
				  ]
			    ],
			    'default' => 'icon',
			    'condition' => [
					'socity_service_select'=> array('1','2'),
				]
			]
		  );
	
		  $this->add_control(
			'socity_sicon_img',
			[
			    'label' => esc_html__('Image','socitycore'),
			    'type'=>Controls_Manager::MEDIA,
			    'default' => [
				  'url' => Utils::get_placeholder_image_src(),
			    ],
			    'condition' => [
				  'service_icons_type' => 'img',
			    ]
			]
		  );
	
		  $this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
			    'name' => 'socity_sicon_img_resize',
			    'default' => 'large',
			    'separator' => 'none',
			    'condition' => [
				   'socity_service_select'=> array('1','2'),
				  'service_icons_type' => 'img',
			    ]
			]
		  );
		$this->add_control(
			'socity_service_icon',
			[
				'label' => esc_html__( 'Icon', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::ICON,
				'condition'=>[
					'socity_service_select'=> array('1','2'),
					'service_icons_type'=> 'icon',
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'socity_service_title',
			[
			    'label'		=> esc_html__( 'Title', 'socitycore' ),
			    'type'        => Controls_Manager::TEXT,
			    'default'     => esc_html__('It Managment','socitycore'),
			    'placeholder' => esc_html__( 'Service Title', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_service_titleicon',
			[
				'label' => esc_html__( 'Title Icon', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::ICON,
				'condition'=>[
					'socity_service_select'=> array('2','3'),
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'socity_service_links',
			[
				'label' => esc_html__( 'Select Link', 'socitycore' ),
				'type'  => Controls_Manager::SELECT,
				'default'	=> 'extranal',
				'options' => [
					'no' => esc_html__( 'Select Options', 'socitycore' ),
					'extranal' => esc_html__( 'Extranal', 'socitycore' ),
					'page' =>  esc_html__( 'Page', 'socitycore' ),
				],
			]
		);
		$this->add_control(
			'socity_service_extranal',
			[
				'label' => esc_html__( 'Extranal Link', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'socity_service_links' => 'extranal',
				],
				'placeholder' => esc_html__( 'Add Extranal Link', 'socitycore' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'socity_service_page_link',
			[
				'label' => esc_html__( 'Page Link', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'options' => socity_page_list(),
				'condition' => [
					'socity_service_links' => 'page',
				],
			]
		);
		$this->add_control(
			'socity_service_dec',
			[
			    'label' => esc_html__( 'Description', 'socitycore' ),
			    'type' => Controls_Manager::WYSIWYG,
			    'default' => esc_html__( 'Lorem ipsum dolor sit amet, consecte adipiscing elit Morbi vitae.','socitycore' ),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_service_box_styles',
			[
			    'label' => esc_html__( 'Box Style', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_service_box_style_tabs');

        	$this->start_controls_tab( 'socity_service_nbox_tab',
			[
				'label' => esc_html__( 'Normal', 'socitycore' ),
			]
		);
		$this->add_responsive_control(
			'socity_service_box_margin',
			[
				'label' => esc_html__( 'Margin', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .service-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_service_box_padding',
			[
				'label' => esc_html__( 'Padding', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .service-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_service_box_bg',
				'label' => esc_html__( 'Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .service-box',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'socity_service_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'socitycore' ),
				'selector' => '{{WRAPPER}} .service-box',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'socity_service_box_border',
				'label' => esc_html__( 'Border', 'socitycore' ),
				'selector' => '{{WRAPPER}} .service-box',
			]
		);
		$this->add_responsive_control(
			'socity_service_box_radius',
			[
				'label' => esc_html__( 'Border Radius', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .service-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab( 'socity_service_hbox_tab',
			[
				'label' => esc_html__( 'Hover', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_service_box_hbg',
				'label' => esc_html__( 'Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .service-box:hover',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'socity_service_box_hshadow',
				'label' => esc_html__( 'Box Shadow', 'socitycore' ),
				'selector' => '{{WRAPPER}} .service-box:hover',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'socity_service_box_hborder',
				'label' => esc_html__( 'Border', 'socitycore' ),
				'selector' => '{{WRAPPER}} .service-box:hover',
			]
		);
		$this->add_responsive_control(
			'socity_service_box_hradius',
			[
				'label' => esc_html__( 'Border Radius', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .service-box:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'socity_service_box_animations',
			[
				'label' => esc_html__( 'Hover Animation', 'socitycore' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
				'prefix_class' => 'elementor-animation-',
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_service_cbox_styles',
			[
			    'label' => esc_html__( 'Content Box', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_service_cbox_margin',
			[
				'label' => esc_html__( 'Margin', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .service-contents' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_service_cbox_padding',
			[
				'label' => esc_html__( 'Padding', 'socitycore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .service-contents' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_service_cbox_bg',
				'label' => esc_html__( 'Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .service-contents',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'socity_service_cbox_border',
				'label' => esc_html__( 'Border', 'socitycore' ),
				'selector' => '{{WRAPPER}} .service-contents',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'socity_service_cbox_hshadow',
				'label' => esc_html__( 'Box Shadow', 'socitycore' ),
				'selector' => '{{WRAPPER}} .service-contents',
			]
		);


		$this->add_control(
			'socity_service_content3_color',
			[
				'label' => esc_html__( 'Content Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .style-three .service-dec p' => 'color: {{VALUE}};',
				],
				'condition' => [
					'socity_service_select' => '3',
				],
			]
		);
		$this->add_control(
			'socity_service_content3h_color',
			[
				'label' => esc_html__( 'Content Hover Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .style-three:hover .service-dec p' => 'color: {{VALUE}};',
				],
				'condition' => [
					'socity_service_select' => '3',
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'socity_service_icons_styles',
			[
			    'label' => esc_html__( 'Icons Style', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_service_icons_style_tabs');

        	$this->start_controls_tab( 'socity_service_ficon_tab',
			[
				'label' => esc_html__( 'Font icon Normal', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_sicon_color',
			[
				'label' => esc_html__( 'Icon Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0b5be0',
				'selectors' => [
					'{{WRAPPER}} .service-icon i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_service_ficon_size',
			[
				'label' => esc_html__( 'Font Icon Size', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 2,
						'max' => 500,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 84,
				],
				'selectors' => [
					'{{WRAPPER}} .service-icon i:before' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_sficon_border_color',
				'label' => esc_html__( 'border color', 'socitycore' ),
				'types' => [ 'classic' ],
				'default' => '#bfbfbf',
				'selector' => '{{WRAPPER}} .service-icon i:after',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab( 'socity_service_ficon_htab',
			[
				'label' => esc_html__( 'Font icon Hover', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_sicon_hcolor',
			[
				'label' => esc_html__( 'Icon Hover Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .service-box:hover .service-icon i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_sficon_hborder_color',
				'label' => esc_html__( 'border Hover', 'socitycore' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .service-box:hover .service-icon i:after',
			]
		);
		$this->end_controls_tab();
		
		$this->end_controls_tabs();
		$this->add_control(
			'line2',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_note_sms1',
			[
				'label' => esc_html__( 'Image ICON', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => esc_html__( 'If You Select image Icon Then Worked This area Options', 'socitycore' ),
				'content_classes' => 'note-message',
			]
		);
		$this->add_responsive_control(
			'socity_service_iicon_size',
			[
				'label' => esc_html__( 'Image Icon Size', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 29,
				],
				'selectors' => [
					'{{WRAPPER}} .service-icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'line3',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_responsive_control(
			'socity_service_icons_alignment',
			[
				'label' => esc_html__( 'Alignment', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'socitycore' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'socitycore' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'socitycore' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .service-icon' => 'text-align: {{VALUE}};',
				],
				'default' => 'center',
				'toggle' => true,
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_service_tite_styles',
			[
			    'label' => esc_html__( 'Title Style', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_service_title_tabs');

        	$this->start_controls_tab( 'socity_service_title_tab',
			[
				'label' => esc_html__( 'Normal', 'socitycore' ),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_service_title_typo',
			    'selector' => '{{WRAPPER}} .service-titles h3',
			]
		);  
		$this->add_control(
			'socity_service_title_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-titles h3 a' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->end_controls_tab();

		$this->start_controls_tab( 'socity_service_titleh_tab',
			[
				'label' => esc_html__( 'Hover', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_service_title_hcolor',
			[
				'label' => esc_html__( 'Hover Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-box:hover .service-titles a' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->add_control(
			'line4',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_responsive_control(
			'socity_service_title_alignment',
			[
				'label' => esc_html__( 'Alignment', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'socitycore' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'socitycore' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'socitycore' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .service-titles h3' => 'text-align: {{VALUE}};',
				],
				'default' => 'center',
				'toggle' => true,
			]
		);
		$this->add_responsive_control(
			'socity_service_title_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .service-titles h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->add_responsive_control(
			'socity_service_title_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'default' => [
				  'top' => '30px',
				  'right' => '0',
				  'bottom' => '20px',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .service-titles h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		); 
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_service_tite_icon_style',
			[
			    'label' => esc_html__( 'Title Icon', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'socity_service_title_icon_color',
			[
				'label' => esc_html__( 'Font Icon Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-title-con i:before' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_responsive_control(
			'socity_service_title_icon_size',
			[
				'label' => esc_html__( 'Font Icon Size', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 5,
						'max' => 300,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 41,
				],
				'selectors' => [
					'{{WRAPPER}} .service-title-con i:before' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'socity_service_title_hicon_color',
			[
				'label' => esc_html__( 'Icon hover Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-box:hover .service-title-con i:before' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_control(
			'ticon1',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_responsive_control(
			'socity_service_title_icon_margin',
			[
				'label' => esc_html__( 'Title Icon Margin Right', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 80,
						'step' => 1,
					],
					'%' => [
						'min' => 5,
						'max' => 50,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .service-title-con' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'socity_service_title_icon_top',
			[
				'label' => esc_html__( 'Title Icon Position', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .service-title-con' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if($settings['socity_service_select'] == 2 ){
			$socity_service_style = 'style-two';
		}elseif($settings['socity_service_select'] == 3 ){
			$socity_service_style = 'style-three';
		}else{
			$socity_service_style = '';
		}
		if( $settings['socity_service_links'] == 'page' ){
			$socity_service_source = get_page_link( $settings['socity_service_page_link'] );
		}else{
			$socity_service_source =  $settings['socity_service_extranal'];
		}
		?>
		<div class="service-box <?php echo esc_attr($socity_service_style); ?> <?php echo esc_attr($settings['socity_service_box_animations']) ?>">
			<?php if(empty($settings['socity_service_select'] == '3'  )) : ?>
			<div class="service-icon">
				<?php 
				if(!empty($settings['service_icons_type'] == 'img' )){
					echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'socity_sicon_img_resize', 'socity_sicon_img' );
				}else{
					echo '<i class="'.esc_attr($settings['socity_service_icon']).'"></i>';
				}
				 ?>
			</div>
			<?php endif; ?>
			<div class="service-contents">
				<?php if(!empty($settings['socity_service_select'] == '2' )) : ?>
				<div class="service-title-con">
				<i class="<?php echo esc_attr($settings['socity_service_titleicon']); ?>"></i>
				</div>
				<?php endif; ?>
				<div class="service-c-inner">
					<div class="service-titles">
						<h3>
						<?php if(!empty($settings['socity_service_select'] == '3' )) : ?>
						<div class="service-title-con">
						<i class="<?php echo esc_attr($settings['socity_service_titleicon']); ?>"></i>
						</div>
						<?php endif; ?>
							<a href="<?php echo esc_url($socity_service_source); ?>"><?php echo esc_html($settings['socity_service_title']); ?></a>
						</h3>
					</div>
					<div class="service-dec">
					<?php echo wp_kses_post(wpautop($settings['socity_service_dec'])); ?>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_service_Widget );