<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_pricing_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-pricing';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Pricing Table', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'Pricing' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_pricing_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_pricing_icon',
			[
			    'label' =>esc_html__('Icon','socitycore'),
			    'type'=>Controls_Manager::ICON,
			    'label_block' => true,
			]
		  );
		$this->add_control(
			'socity_pricing_title',
			[
			    'label' => esc_html__( 'Title', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Pricing Title','socitycore'),
			]
		);
		$this->add_control(
			'socity_pricing_title_label',
			[
			    'label' => esc_html__( 'Title Label', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('label','socitycore'),
			]
		);
		$this->add_control(
			'socity_pricing_month',
			[
			    'label' => esc_html__( 'Month/Year', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Per year','socitycore'),
			]
		);
		$this->add_control(
			'socity_pricing_money',
			[
			    'label' => esc_html__( 'Amount with Currency ', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => '$99.99',
			]
		);
		$this->add_control(
			'socity_pricing_dec',
			[
			    'label' => esc_html__( 'Amount with Currency ', 'socitycore' ),
			    'type' => Controls_Manager::WYSIWYG,
			    'default'       => wp_kses(
				    __('
				    <ul>
				    	<li>Brandwidth: <strong>2GB</strong></li>
				    	<li>Clint & Product: <strong>2GB</strong></li>
				    	<li>onlinespace: <strong>2GB</strong></li>
				    	<li>Domain: <strong>2</strong></li>
				    	<li>Hidden Fees: <strong>0</strong></li>
				    </ul>','socitycore'),
				    array(
					'ul' => array(),
					'li' => array(),
					'strong' => array(),
					'span' => array(),
				    )
			    ),
			]
		);
		$this->add_control(
			'socity_pricing_link',
			[
			    'label' => esc_html__( 'button Link', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'socity_pricing_link_text',
			[
			    'label' => esc_html__( 'Button Text', 'socitycore' ),
			    'type'        => Controls_Manager::TEXT,
			    'default'	=> esc_html('Select plan','socitycore'),
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_pricing_border_styles',
			[
			    'label' => esc_html__( 'Pricing box', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'socity_pricing_border',
				'label' => esc_html__( 'Border', 'socitycore' ),
				'selector' => '{{WRAPPER}} .pricing-box',
			]
		);
		$this->add_responsive_control(
			'socity_pricing_alignment',
			[
				'label' => esc_html__( 'Alignment', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'socitycore' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'socitycore' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'socitycore' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .pricing-box' => 'text-align: {{VALUE}};',
				],
				'default' => 'center',
				'toggle' => true,
			]
		);
		$this->add_responsive_control(
			'socity_pricing_box_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .pricing-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->add_responsive_control(
			'socity_pricing_box_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .pricing-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_pricing_icon_styles',
			[
			    'label' => esc_html__( 'Pricing Icon', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_pricing_icon_font',
			[
				'label' => esc_html__( 'Font Icon Size', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 40,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 55,
				],
				'selectors' => [
					'{{WRAPPER}} .pricing-icon i:before' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'socity_pricing_icon_font_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default'	=>'#0a5be0',
				'selectors' => [
					'{{WRAPPER}} .pricing-icon i:before' => 'color: {{VALUE}};',
				],
			]
		); 

		$this->add_responsive_control(
			'socity_pricing_icon_padding',
			[
				'label' => esc_html__( 'Top', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => -27,
				],
				'selectors' => [
					'{{WRAPPER}} .pricing-icon' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_pricing_header_styles',
			[
			    'label' => esc_html__( 'Pricing Header', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->start_controls_tabs('socity_pricing_header_tabs');

        	$this->start_controls_tab( 'socity_pricing_header_title_tab',
			[
				'label' => esc_html__( 'Title', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_pricing_title_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default'	=>'#000000',
				'selectors' => [
					'{{WRAPPER}} .pricing-title h2' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'socity_pricing_title_typo',
				'selector' => '{{WRAPPER}} .pricing-title h2',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab( 'socity_pricing_header_year_tab',
			[
				'label' => esc_html__( 'Year', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_pricing_year_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default'	=>'#0a5be0',
				'selectors' => [
					'{{WRAPPER}} .pricing-year h4' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'socity_pricing_year_typo',
				'selector' => '{{WRAPPER}} .pricing-year h4',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab( 'socity_pricing_header_amount_tab',
			[
				'label' => esc_html__( 'Amount', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_pricing_amount_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default'	=>'#000000',
				'selectors' => [
					'{{WRAPPER}} .pricing-amount h1' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'socity_pricing_amount_typo',
				'selector' => '{{WRAPPER}} .pricing-amount h1',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->add_control(
			'line2',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_responsive_control(
			'socity_pricing_header_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .pricing-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->add_responsive_control(
			'socity_pricing_header_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .pricing-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_pricing_body_styles',
			[
			    'label' => esc_html__( 'Pricing Body', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'socity_pricing_body_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default'	=>'#798795',
				'selectors' => [
					'{{WRAPPER}} .pricing-body ul li' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'socity_pricing_body_typo',
				'selector' => '{{WRAPPER}} .pricing-body',
			]
		);
		$this->add_control(
			'socity_pricing_body_border_color',
			[
				'label' => esc_html__( 'border Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default'	=>'#e6e6e6',
				'selectors' => [
					'{{WRAPPER}} .pricing-body ul li' => 'border-color: {{VALUE}};',
				],
			]
		); 
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_pricing_footer_styles',
			[
			    'label' => esc_html__( 'Pricing Footer', 'socitycore' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'socity_pricing_footer_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default'	=>'#798795',
				'selectors' => [
					'{{WRAPPER}} .pricing-footer a.theme-button' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_pricing_footer_bg',
				'label' => esc_html__( 'Button Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .pricing-footer a.theme-button',
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'socity_pricing_footer_typo',
				'selector' => '{{WRAPPER}} .pricing-footer a.theme-button',
			]
		);
		$this->add_control(
			'line3',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'socity_note1',
			[
				'label' => __( '<strong>Hover background Color</strong>', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'content_classes' => 'note-message',
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_pricing_footer_hbg',
				'label' => esc_html__( 'Button Hover Background', 'socitycore' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .pricing-footer a.theme-button:hover',
			]
		);
		$this->add_control(
			'socity_pricing_footer_hcolor',
			[
				'label' => esc_html__( 'Hover Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'default'	=>'#ffffff',
				'selectors' => [
					'{{WRAPPER}} .pricing-footer a.theme-button:hover' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_responsive_control(
			'socity_pricing_footer_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .pricing-footer' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],                
			    'default' => [
				  'top' => '0',
				  'right' => '0',
				  'bottom' => '0',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'separator' =>'before',
			]
		);
		$this->add_responsive_control(
			'socity_pricing_footer_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .pricing-footer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],                
			    'default' => [
				  'top' => '70',
				  'right' => '0',
				  'bottom' => '70',
				  'left' => '0',
				  'isLinked' => false
			    ],
			    'separator' =>'before',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		?>
		<div class="pricing-box">
			<?php if(!empty($settings['socity_pricing_icon'] )) : ?>
			<div class="pricing-icon">
			<i class="<?php echo esc_attr($settings['socity_pricing_icon']); ?>"></i>
			</div>
			<?php endif; ?>
			<div class="pricing-header">
				<div class="pricing-title">
			<h2><?php echo esc_html($settings['socity_pricing_title']); ?><?php if(!empty($settings['socity_pricing_title_label'])) : ?><label><?php echo esc_html($settings['socity_pricing_title_label']) ?></label><?php endif; ?></h2>
				</div>
				<div class="pricing-year">
					<h4><?php echo esc_html($settings['socity_pricing_month']); ?></h4>
				</div>
				<div class="pricing-amount">
					<h1><?php echo esc_html($settings['socity_pricing_money']) ?></h1>
				</div>
			</div>
			<div class="pricing-body">
				<?php echo wp_kses_post(wpautop($settings['socity_pricing_dec'] )); ?>
			</div>
			<div class="pricing-footer">
				<div class="theme-buttons">
					<a href="<?php echo esc_url($settings['socity_pricing_link']) ?>" class="theme-button"><?php echo esc_html($settings['socity_pricing_link_text']); ?><i class="flaticon-right-arrow"></i></a>
				</div>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_pricing_Widget );