<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_contact_message_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-contact-message';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Contact Message', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'Contact Message' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_contact_message_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_contact_message_hadding',
			[
			    'label' => esc_html__( 'Hadding', 'socitycore' ),
			    'type' => Controls_Manager::TEXTAREA,
			    'default' => esc_html__( 'If you have any query about us and our services, then fell free to contact with us.','socitycore' ),
			    'placeholder' => esc_html__( 'Title Hadding', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_contact_sms_btn_text',
			[
			    'label' => esc_html__( 'Button Text', 'socitycore' ),
			    'type' => Controls_Manager::TEXT,
			    'default' => esc_html__( 'Contact Us','socitycore' ),
			]
		);
		$this->add_control(
			'socity_contact_message_links',
			[
				'label' => esc_html__( 'Select Link', 'socitycore' ),
				'type'  => Controls_Manager::SELECT,
				'default'	=> 'extranal',
				'options' => [
					'no' => esc_html__( 'Select Options', 'socitycore' ),
					'extranal' => esc_html__( 'Extranal', 'socitycore' ),
					'page' =>  esc_html__( 'Page', 'socitycore' ),
				]
			]
		);
		$this->add_control(
			'socity_contact_message_extranal',
			[
				'label' => esc_html__( 'Extranal Link', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => array(
					'socity_contact_message_links' => 'extranal',
				),
				'placeholder' => esc_html__( 'Add Extranal Link', 'socitycore' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'socity_contact_message_page_link',
			[
				'label' => esc_html__( 'Page Link', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'options' => socity_page_list(),
				'condition' => array(
					'socity_contact_message_links' => 'page',
				),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_con_sms_content_styles',
			[
				'label' => esc_html__( 'content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'socity_cont_sms_scolor',
			[
				'label' => esc_html__( 'Hadding Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ctn-sms-hadding h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_sms_typrography',
			    'label' => esc_html__( 'Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .ctn-sms-hadding h2',
			]
		);
		$this->add_responsive_control(
			'socity_sms_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .contact_sms-boxs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->add_responsive_control(
			'socity_sms_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .contact_sms-boxs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if( $settings['socity_contact_message_links'] == 'page' ){
			$contat_source = get_page_link( $settings['socity_contact_message_page_link'] );
		}else{
			$contat_source =  $settings['socity_contact_message_extranal'];
		}
		?>
		<div class="contact_sms-boxs">
			<div class="contact-sms-row row">
				<div class="col-12-col-sm-6 col-md-6 col-lg-7 col-xl-7 d-flex align-items-center">
					<div class="ctn-sms-hadding">
						<h2><?php echo esc_html($settings['socity_contact_message_hadding']); ?></h2>
					</div>
				</div>
				<div class="col-12-col-sm-6 col-md-6 col-lg-5 col-xl-5 d-flex align-items-center justify-content-end">
					<div class="ctn-sms-btn">
						<div class="theme-buttons">
							<a href="<?php echo esc_url($contat_source); ?>" class="theme-button"><?php echo esc_html($settings['socity_contact_sms_btn_text']) ?> <i class="flaticon-right-arrow"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_contact_message_Widget );