<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_clients_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-client';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Client', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'client' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_clients_contens',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new \Elementor\Repeater();
            
            $repeater->add_control(
			'socity_client_logo', [
				'label' => esc_html__( 'Client Logo', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'socity_clili_enable',
			[
			    'label'         => esc_html__( 'Enable Link', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'yes',
			]
		);
		$repeater->add_control(
			'socity_client_links',
			[
				'label' => esc_html__( 'Select Link', 'socitycore' ),
				'type'  => Controls_Manager::SELECT,
				'default'	=> 'extranal',
				'options' => [
					'no' => esc_html__( 'Select Options', 'socitycore' ),
					'extranal' => esc_html__( 'Extranal', 'socitycore' ),
					'page' =>  esc_html__( 'Page', 'socitycore' ),
				],
				'condition' 	=> [
                        	'socity_clili_enable' => 'yes',
                  	]
			]
		);
		$repeater->add_control(
			'socity_client_extranal',
			[
				'label' => esc_html__( 'Extranal Link', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => array(
					'socity_client_links' => 'extranal',
					'socity_clili_enable' => 'yes',
				),
				'placeholder' => esc_html__( 'Add Extranal Link', 'socitycore' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'socity_client_page_link',
			[
				'label' => esc_html__( 'Page Link', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'options' => socity_page_list(),
				'condition' => array(
					'socity_client_links' => 'page',
					'socity_clili_enable' => 'yes',
				),
			]
		);
		$this->add_control(
			'socity_client_slides',
			[
				'label' => esc_html__( 'Clients', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'socity_client_logo' => esc_html__( 'Client Iamge', 'socitycore' ),
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'socity_clients_config',
			[
				'label' => esc_html__( 'Slide Configaration', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_client_slide_on',
			[
				'label'         => esc_html__( 'Enable Slider ', 'socitycore' ),
			    	'type'          => Controls_Manager::SWITCHER,
			    	'label_on'      => esc_html__( 'On', 'socitycore' ),
			    	'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    	'return_value'  => 'yes',
			    	'default'       => 'no',
			]
		);
		$this->add_control(
			'socity_clsl_loop',
			[
			    'label'         => esc_html__( 'Enable Loop ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'no',
			    'condition' 	=> [
                        	'socity_client_slide_on' => 'yes',
                  	]
			]
		);
		$this->add_control(
			'socity_clsl_speed',
			[
				'label' 	=> esc_html__( 'Slide Speed', 'socitycore' ),
			    	'type' 	=> Controls_Manager::NUMBER,
			    	'min' 	=> 500,
			    	'max' 	=> 5000,
			    	'step' 	=> 10,
			    	'default' 	=> 1000,
				'condition' => array(
					'socity_client_slide_on' 	=> 'yes',
					'socity_clsl_loop' 		=> 'yes',
					
				)
			]
		);
		$this->add_control(
			'socity_clsl_aloop',
			[
			    'label'         => esc_html__( 'Enable Auto Loop ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'no',
			    'condition' 	=> [
                        	'socity_clsl_loop' => 'yes',
                  	]
			]
		);
		$this->add_control(
			'socity_clsl_aspeed',
			[
				'label' 	=> esc_html__( 'Slide auto Speed', 'socitycore' ),
			    	'type' 	=> Controls_Manager::NUMBER,
			    	'min' 	=> 500,
			    	'max' 	=> 5000,
			    	'step' 	=> 50,
			    	'default' 	=> 1000,
			   	'condition' => array(
					'socity_clsl_aloop' => 'yes',
					'socity_clsl_loop' 	=> 'yes',
					'socity_client_slide_on' 	=> 'yes',
					
				)
			]
		);
		$this->add_control(
			'socity_clsl_nav',
			[
			    'label'         => esc_html__( 'Enable Nav ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'no',
			    'condition' 	=> [
                        	'socity_client_slide_on' => 'yes',
                  	]
			]
		);
		$this->add_control(
			'socity_clsl_dot',
			[
			    'label'         => esc_html__( 'Enable Dots ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'no',
			    'condition' 	=> [
                        	'socity_client_slide_on' => 'yes',
                  	]
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_client_styles',
			[
				'label' => esc_html__( 'Style', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_client_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .client-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		  );        
		  $this->add_responsive_control(
			'socity_client_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .client-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		  );   
		  $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'label' => esc_html__( 'Border', 'socitycore' ),
				'selector' => '{{WRAPPER}} .client-section',
			]
		);
		$this->add_control(
			'socity_client_filter',
			[
				'label' => __( 'Filter Color', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					
					'%' => [
						'min' => 0,
						'max' => 800,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .client-items .item img' => 'filter:saturate({{SIZE}}{{UNIT}});',
				],
			]
		);
		$this->add_control(
			'socity_client_opacity',
			[
				'label' => __( 'Opacity', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					
					'%' => [
						'min' => 0.1,
						'max' => 1,
					],
				],
				'default' => [
					'size' => .4,
				],
				'selectors' => [
					'{{WRAPPER}} .client-items .item img' => 'opacity:{{SIZE}};',
				],
			]
		);
		$this->add_control(
			'socity_client_filterh',
			[
				'label' => __( 'Hover Filter Color', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					
					'%' => [
						'min' => 0,
						'max' => 800,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .client-items .item img:hover' => 'filter:saturate({{SIZE}}{{UNIT}});',
				],
			]
		);
		$this->add_control(
			'socity_client_opacityh',
			[
				'label' => __( 'Hover Opacity', 'socitycore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					
					'%' => [
						'min' => 0.1,
						'max' => 1,
					],
				],
				
				'selectors' => [
					'{{WRAPPER}} .client-items .item img:hover' => 'opacity:{{SIZE}};',
				],
			]
		);
		$this->end_controls_section();
	
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$dynamic_id = rand(1241, 3256);
		if($settings['socity_client_slide_on'] == 'yes' ){
			if($settings['socity_clsl_dot'] == 'yes' ){
				$dots = 'true';
			}else{
				$dots = 'false';
			}
			if($settings['socity_clsl_nav'] == 'yes' ){
				$nav = 'true';
			}else{
				$nav = 'false';
			}
			if($settings['socity_clsl_aloop'] == 'yes' ){
				$aloop = 'true';
			}else{
				$aloop = 'false';
			}
			if($settings['socity_clsl_loop'] == 'yes' ){
				$loop = 'true';
			}else{
				$loop = 'false';
			}
			echo '
			<script>
			jQuery(document).ready(function($) {
				"use strict";
				$("#clients-'.esc_attr($dynamic_id).'").slick({
					slidesToShow: 5,
					slidesToScroll: 1,
					dots: '.esc_attr($dots).',
					infinite: '.esc_attr($loop).',
					autoplay: '.esc_attr($aloop).',
					arrows: '.esc_attr($nav).',';
					if($aloop == 'true'){
					echo 'speed: '.esc_attr($settings['socity_clsl_speed']).',';
					}
					if($aloop == 'true'){
					echo 'autoplaySpeed: '.esc_attr($settings['socity_clsl_aspeed']).',';
					}
					echo '
					responsive: [
						{
						breakpoint: 1024,
							settings: {
								slidesToShow: 3,
								slidesToScroll: 3,
								infinite: true,
								dots: true
							}
						},
						{
							breakpoint: 600,
							settings: {
								slidesToShow: 2,
								slidesToScroll: 2
							}
						},
						{
							breakpoint: 480,
							settings: {
								slidesToShow: 1,
								slidesToScroll: 1
							}
						}
					]
				});
			});
			</script>';
            }
		?>
		<?php if( !empty( $settings['socity_client_slides']) ) : ?>
		<div class="client-section">
			<div class="client-items" id="clients-<?php echo esc_attr($dynamic_id); ?>">
			<?php foreach ( $settings['socity_client_slides'] as $socity_client_slide  ) :
			if( $socity_client_slide['socity_client_links'] == 'page' ){
				$clientource = get_page_link( $socity_client_slide['socity_client_page_link'] );
			}else{
				$clientource =  $socity_client_slide['socity_client_extranal'];
			}
			?>
			<div class="item">
				<?php if(!empty( $socity_client_slide['socity_clili_enable'] == true )) : ?>
				<a href="<?php echo esc_url($clientource); ?>">
					<?php echo wp_get_attachment_image( $socity_client_slide['socity_client_logo']['id'], 'large' ); ?>
				</a>
				<?php else : ?>
					<?php echo wp_get_attachment_image( $socity_client_slide['socity_client_logo']['id'], 'large' ); ?>
				<?php endif; ?>
			</div>
			<?php endforeach; ?>
			</div>
		</div>
		<?php endif; ?>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_clients_Widget );