<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_buttons_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-buttons';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Buttons', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'buttons' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_buttons_section',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'socity_button_style',
			[
				'label' => esc_html__( 'Select Buttons', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  	=> esc_html__( 'Style One', 'socitycore' ),
					'2' 	=> esc_html__( 'Style Two', 'socitycore' ),
				],
			]
		);
		$this->add_control(
			'socity_buttons_links',
			[
				'label' => esc_html__( 'Select Link', 'socitycore' ),
				'type'  => Controls_Manager::SELECT,
				'default'	=> 'extranal',
				'options' => [
					'extranal' => esc_html__( 'Extranal', 'socitycore' ),
					'page' =>  esc_html__( 'Page', 'socitycore' ),
				],
			]
		);
		$this->add_control(
			'socity_buttons_link_extralnal',
			[
				'label' => esc_html__( 'Extranal Link', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'socity_buttons_links' => 'extranal',
				],
				'placeholder' => esc_html__( 'Add Extranal Link', 'socitycore' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'socity_buttons_page_link',
			[
				'label' => esc_html__( 'Page Link', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'options' => socity_page_list(),
				'condition' => [
					'socity_buttons_links' => 'page',
				],
			]
		);
		$this->add_control(
			'socity_buttons_static_test',
			[
			    'label' => esc_html__( 'Readmore Text', 'socitycore' ),
			    'type'          => Controls_Manager::TEXTAREA,
			    'default'       => esc_html__('We work creatively and specially for our client','socitycore'),
			    'condition' => [
					'socity_button_style' => '2',
			    ],
			]
		);
		$this->add_control(
			'socity_buttons_readmore_link_test',
			[
			    'label' => esc_html__( 'Button Link Text', 'socitycore' ),
			    'type'          => Controls_Manager::TEXT,
			    'default'       => esc_html__('Check Our Protfolo','socitycore')
			]
		);
		$this->add_control(
			'socity_button_new_tab',
			[
			    'label'         => esc_html__( 'Open New Tab ? ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'Yes', 'socitycore' ),
			    'label_off'     => esc_html__( 'No', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'no',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_buttons_style',
			[
				'label' => esc_html__( 'Style', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_buttons_tabs');

		$this->start_controls_tab( 'socity_buttons_tab1',
			[
				'label' => esc_html__( 'Style One', 'socitycore' ),
			]
		);   
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'socitycore' ),
			    	'name' => 'socity_buttons_style1_typo',
			    	'selector' => '{{WRAPPER}} .socity-theme-buttons a.theme-button',
			]
		);   
		$this->add_control(
			'socity_buttons_style1_color',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-theme-buttons a.theme-button' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_buttons_style1_bg',
				'label' => esc_html__( 'background color', 'socitycore' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .socity-theme-buttons a.theme-button',
			]
		);
		$this->add_responsive_control(
			'socity_buttons_style1_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .socity-theme-buttons a.theme-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);        
		$this->add_responsive_control(
			'socity_buttons_style1_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'default' => [
					'top' => '17',
					'right' => '30',
					'bottom' => '17',
					'left' => '30',
					'isLinked' => false
			  	],
			    'selectors' => [
				 	 '{{WRAPPER}} .socity-theme-buttons a.theme-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    	],
			    'separator' =>'before',
			]
		);   
		$this->add_control(
			'btn_line',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'important_note',
			[
				'label' => __( '<strong>Button Hover Section</strong>', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
			]
		);
		$this->add_control(
			'socity_buttons_style1_hcolor',
			[
				'label' => esc_html__( 'Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-theme-buttons a.theme-button:hover' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'socity_buttons_style1_hbg',
				'label' => esc_html__( 'background color', 'socitycore' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .socity-theme-buttons a.theme-button:hover',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab( 'socity_buttons_tab2',
			[
				'label' => esc_html__( 'Style Two', 'socitycore' ),
			]
		);      
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'link Typography', 'socitycore' ),
			    	'name' => 'socity_buttons_style2_typo',
			    	'selector' => '{{WRAPPER}} .socity-theme-buttons.button-style-2 .theme-button',
			]
		);   
		$this->add_control(
			'socity_buttons_style2_color',
			[
				'label' => esc_html__( 'Link Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-theme-buttons.button-style-2 .theme-button' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_control(
			'socity_buttons_style2_hcolor',
			[
				'label' => esc_html__( 'Link Hover Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-theme-buttons.button-style-2 .theme-button:hover' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_control(
			'btn_line2',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'important_note2',
			[
				'label' => __( '<strong>Busston Style Two Static Test </strong>', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Static Text Typography', 'socitycore' ),
			    	'name' => 'socity_buttons_style2_stypo',
			    	'selector' => '{{WRAPPER}} .socity-theme-buttons.button-style-2 .theme-buttons span',
			]
		);   
		$this->add_control(
			'socity_buttons_style2_scolor',
			[
				'label' => esc_html__( 'Static Text Color', 'socitycore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .socity-theme-buttons.button-style-2 .theme-buttons span' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_buttons_box',
			[
				'label' => esc_html__( 'Box', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'socity_buttons_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .socity-theme-buttons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);        
		$this->add_responsive_control(
			'socity_buttons_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .socity-theme-buttons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		);   
		$this->add_responsive_control(
			'socity_buttons_alignment',
			[
			    'label' => esc_html__( 'Alignment', 'socitycore' ),
			    'type' => Controls_Manager::CHOOSE,
			    'options' => [
				  'left' => [
					'title' => esc_html__( 'Left', 'socitycore' ),
					'icon' => 'fa fa-align-left',
				  ],
				  'center' => [
					'title' => esc_html__( 'Center', 'socitycore' ),
					'icon' => 'fa fa-align-center',
				  ],
				  'right' => [
					'title' => esc_html__( 'Right', 'socitycore' ),
					'icon' => 'fa fa-align-right',
				  ]
			    ],
			    'selectors' => [
				  '{{WRAPPER}} .socity-theme-buttons' => 'text-align: {{VALUE}};',
			    ],
			    'separator' =>'before',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if( $settings['socity_buttons_links'] == 'page' ){
			$socity_btn_page = get_page_link( $settings['socity_buttons_page_link'] );
		}else{
			$socity_btn_page =  $settings['socity_buttons_link_extralnal'];
		}
		?>
		<div class="socity-theme-buttons <?php if(!empty($settings['socity_button_style'] == '2' )) : ?>button-style-2<?php endif; ?>">
			<div class="theme-buttons">
				<?php if(!empty($settings['socity_button_style'] == '2' )) : ?>
					<span><?php echo esc_html($settings['socity_buttons_static_test']); ?></span>
				<?php endif; ?>
				<a <?php if(!empty($settings['socity_button_new_tab'] == 'yes' )) : ?>target="_blank"<?php endif; ?> href="<?php echo esc_url($socity_btn_page) ?>" class="theme-button colorbg">
					<?php echo esc_html($settings['socity_buttons_readmore_link_test']) ?><i class="flaticon-right-arrow"></i>
				</a>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_buttons_Widget );