<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_blog_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-blog';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity Blog', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'blog' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_blog_section',
			[
				'label' => esc_html__( 'content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'socity_blog_style',
            [
                'label' => esc_html__( 'Select Style', 'socitycore' ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1'  => esc_html__( 'Style One', 'socitycore' ),
                    '2'  => esc_html__( 'Style Two', 'socitycore' ),
                ],
            ]
	  );
	  
	$this->end_controls_section();
	$this->start_controls_section(
		'socity_blog_styles',
		[
			'label' => esc_html__( 'Top Area', 'socitycore' ),
			'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		]
	);
	$this->add_control(
		'socity_blog_top_color',
		[
			'label' => esc_html__( 'Color', 'socitycore' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .blog-top ul li' => 'color: {{VALUE}};',
			],
		]
	); 
	$this->add_group_control(
		Group_Control_Typography::get_type(),
		[
		    'name' => 'socity_blog_top__typo',
		    'label' => esc_html__( 'Typography', 'socitycore' ),
		    'selector' => '{{WRAPPER}} .blog-top ul li,.blog-top ul li a',
		]
	);
	$this->add_responsive_control(
		'socity_blog_top_padding',
		[
		    'label' => esc_html__( 'Padding', 'socitycore' ),
		    'type' => Controls_Manager::DIMENSIONS,
		    'size_units' => [ 'px', '%', 'em' ],
		    'selectors' => [
			  '{{WRAPPER}} .blog-top' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		    ],
		    'separator' =>'before',
		]
	); 
	$this->add_responsive_control(
		'socity_blog_top_margin',
		[
		    'label' => esc_html__( 'Margin', 'socitycore' ),
		    'type' => Controls_Manager::DIMENSIONS,
		    'size_units' => [ 'px', '%', 'em' ],
		    'selectors' => [
			  '{{WRAPPER}} .blog-top' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		    ],
		    'separator' =>'before',
		]
	); 
	$this->add_responsive_control(
		'socity_blog_top_aline',
		[
			'label' => esc_html__( 'aligment', 'socitycore' ),
			'type' => Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'socitycore' ),
					'icon' => 'fa fa-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'socitycore' ),
					'icon' => 'fa fa-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'socitycore' ),
					'icon' => 'fa fa-align-right',
				],
			],
			'separator' => 'before',
			'default' => 'left',
			'selectors' => [
				'{{WRAPPER}} .blog-top' => 'text-align: {{VALUE}};',
			],
		]
	);
      $this->end_controls_section();
	$this->start_controls_section(
		'socity_blog_titles_styles',
		[
			'label' => esc_html__( 'Title', 'socitycore' ),
			'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		]
	);
	$this->add_responsive_control(
		'socity_blog_p_right',
		[
			'label' => esc_html__( 'Padding Right', 'socitycore' ),
			'type' => Controls_Manager::SLIDER,
			'size_units' => [ 'px', '%' ],
			'range' => [
				'px' => [
					'min' => 10,
					'max' => 200,
					'step' => 1,
				],
				'%' => [
					'min' => 5,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => '%',
				'size' => 37,
			],
			'selectors' => [
				'{{WRAPPER}} .blog-boxs.blog-post-2 .col-lg-7.col-xl-7 .blog-title h2' => 'padding-right: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'socity_blog_style' => '2',
			  ]
		]
	);
	$this->add_control(
		'socity_blog_title_color',
		[
			'label' => esc_html__( 'Color', 'socitycore' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .blog-title h2 a' => 'color: {{VALUE}};',
			],
		]
	); 
	$this->add_control(
		'socity_blog_title_hcolor',
		[
			'label' => esc_html__( 'Hover Color', 'socitycore' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .blog-title h2 a:hover' => 'color: {{VALUE}};',
			],
		]
	); 
	$this->add_group_control(
		Group_Control_Typography::get_type(),
		[
		    'name' => 'socity_blog_title__typo',
		    'label' => esc_html__( 'Typography', 'socitycore' ),
		    'selector' => '{{WRAPPER}} .blog-title h2 a',
		]
	);
	$this->add_responsive_control(
		'socity_blog_title_padding',
		[
		    'label' => esc_html__( 'Padding', 'socitycore' ),
		    'type' => Controls_Manager::DIMENSIONS,
		    'size_units' => [ 'px', '%', 'em' ],
		    'selectors' => [
			  '{{WRAPPER}} .blog-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		    ],
		    'separator' =>'before',
		]
	); 
	$this->add_responsive_control(
		'socity_blog_title_margin',
		[
		    'label' => esc_html__( 'Margin', 'socitycore' ),
		    'type' => Controls_Manager::DIMENSIONS,
		    'size_units' => [ 'px', '%', 'em' ],
		    'selectors' => [
			  '{{WRAPPER}} .blog-title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		    ],
		    'separator' =>'before',
		]
	); 
	$this->end_controls_section();
	$this->start_controls_section(
		'socity_blog_content_styles',
		[
			'label' => esc_html__( 'Content', 'socitycore' ),
			'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		]
	);
	$this->add_responsive_control(
		'socity_blog_dec_padding',
		[
		    'label' => esc_html__( 'Padding', 'socitycore' ),
		    'type' => Controls_Manager::DIMENSIONS,
		    'size_units' => [ 'px', '%', 'em' ],
		    'selectors' => [
			  '{{WRAPPER}} .blog-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		    ],
		    'separator' =>'before',
		]
	); 
	$this->add_responsive_control(
		'socity_blog_dec_margin',
		[
		    'label' => esc_html__( 'Margin', 'socitycore' ),
		    'type' => Controls_Manager::DIMENSIONS,
		    'size_units' => [ 'px', '%', 'em' ],
		    'selectors' => [
			  '{{WRAPPER}} .blog-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		    ],
		    'separator' =>'before',
		]
	); 
	$this->add_responsive_control(
		'socity_blog_dec_lineheight',
		[
			'label' => esc_html__( 'Line Height', 'socitycore' ),
			'type' => Controls_Manager::SLIDER,
			'size_units' => [ 'px' ],
			'range' => [
				'px' => [
					'min' => 24,
					'max' => 100,
					'step' => 1,
				]
			],
			'default' => [
				'unit' => 'px',
				'size' => 30,
			],
			'selectors' => [
				'{{WRAPPER}} .blog-body p' => 'line-height: {{SIZE}}{{UNIT}};',
			],
		]
	);
	$this->end_controls_section();
	$this->start_controls_section(
		'socity_blog_buttons_styles',
		[
			'label' => esc_html__( 'Button Area', 'socitycore' ),
			'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		]
	);
	$this->add_control(
		'socity_blog_btn_color',
		[
			'label' => esc_html__( 'Color', 'socitycore' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .blog-footer a.theme-button' => 'color: {{VALUE}};',
			],
		]
	); 
	$this->add_control(
		'socity_blog_btn_hcolor',
		[
			'label' => esc_html__( 'Hover Color', 'socitycore' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .blog-footer a.theme-button:hover' => 'color: {{VALUE}};',
			],
		]
	); 
	$this->add_group_control(
		Group_Control_Background::get_type(),
		[
			'name' => 'socity_blog_btn_bg',
			'label' => esc_html__( 'Background', 'socitycore' ),
			'types' => [ 'classic', 'gradient' ],
			'selector' => '{{WRAPPER}} .blog-footer a.theme-button',
		]
	);
	$this->add_group_control(
		Group_Control_Typography::get_type(),
		[
		    'name' => 'socity_blog_btn__typo',
		    'label' => esc_html__( 'Typography', 'socitycore' ),
		    'selector' => '{{WRAPPER}} .blog-footer a.theme-button',
		]
	);
	$this->add_control(
            'blogl',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
	);
	$this->add_control(
		'important_note',
		[
			'label' => __( '<strong>background hover</strong>', 'socitycore' ),
			'type' => Controls_Manager::RAW_HTML,
		]
	);
	$this->add_group_control(
		Group_Control_Background::get_type(),
		[
			'name' => 'socity_blog_btn_hbg',
			'label' => esc_html__( 'Hover Background', 'socitycore' ),
			'types' => [ 'classic', 'gradient' ],
			'selector' => '{{WRAPPER}} .blog-footer a.theme-button:hover',
		]
	);
	$this->add_responsive_control(
		'socity_blog_btn_padding',
		[
		    'label' => esc_html__( 'Padding', 'socitycore' ),
		    'type' => Controls_Manager::DIMENSIONS,
		    'size_units' => [ 'px', '%', 'em' ],
		    'selectors' => [
			  '{{WRAPPER}} .blog-footer a.theme-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		    ],
		    'separator' =>'before',
		]
	); 
	$this->add_responsive_control(
		'socity_blog_btn_margin',
		[
		    'label' => esc_html__( 'Margin', 'socitycore' ),
		    'type' => Controls_Manager::DIMENSIONS,
		    'size_units' => [ 'px', '%', 'em' ],
		    'selectors' => [
			  '{{WRAPPER}} .blog-footer a.theme-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		    ],
		    'separator' =>'before',
		]
	); 
	$this->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'socity_blog_btn_border',
			'label' => esc_html__( 'Border', 'socitycore' ),
			'selector' => '{{WRAPPER}} .blog-footer a.theme-button',
		]
	);
	$this->add_responsive_control(
		'socity_blog_btn_border_radius',
		[
			'label' => esc_html__( 'Border Radius', 'socitycore' ),
			'type' => Controls_Manager::SLIDER,
			'size_units' => [ 'px','%' ],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
					'step' => 1,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
					'step' => 1,
				]
			],
			'default' => [
				'unit' => 'px',
				'size' => 5,
			],
			'selectors' => [
				'{{WRAPPER}} .blog-footer a.theme-button' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]
	);
      $this->end_controls_section();
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
	$settings = $this->get_settings_for_display();
	if($settings['socity_blog_style'] == '2'){
		$post_num = '2';
	}else{
		$post_num = '3';
	}
	?>
	<div class="blog-boxs blog-post-<?php echo esc_attr($post_num); ?>">
		<div class="blog-box">
                <div class="blog-items row">
		     <?php  
		     global $post;
		     $count = 0;
                 $p = new \WP_Query(array('posts_per_page' => esc_attr($post_num), 'post_type' => 'post' ));
			  while($p->have_posts()) : $p->the_post();
			  $count ++;
                    ?>
                    <div class="item <?php if($settings['socity_blog_style'] == '2' ) :  ?>col-12 col-md-6 <?php if($count == 1 ) : ?>col-lg-7 col-xl-7<?php else : ?>col-lg-5 col-xl-5<?php endif; ?><?php else : ?>col-12 col-md-6 col-lg-4 col-xl-4<?php endif; ?>">
                        <div id="post-<?php the_ID(); ?>" <?php post_class('post-single'); ?>>
                            <div class="blog-image">
                                <?php the_post_thumbnail(); ?>
                            </div>
                            <div class="blog-contents">
                               <div class="blog-top">
						 <ul>
						 	<li class="postby"><?php socity_posted_by(); ?></li>
							<li class="date"><?php echo get_the_date(); ?></li>
						 </ul>
                               </div>
                               <div class="blog-title">
                                    <h2><a href="<?php echo esc_url( the_permalink() ); ?>"><?php the_title(); ?></a></h2>
                                </div>
                               <div class="blog-body">
					<?php if($settings['socity_blog_style'] == '2' && $count == 1 ) :  ?> 
						<p><?php echo wp_trim_words( get_the_content(), 25 ); ?></p>
					<?php else : ?>
						<p><?php echo wp_trim_words( get_the_content(), 15 ); ?></p>
					<?php endif; ?>
                               </div>
                               <div class="blog-footer">
                                   <div class="left">
                                        <div class="theme-buttons">
                                            <a href="<?php echo esc_url( the_permalink() ); ?>" class="theme-button"><?php esc_html_e('Read More','socitycore'); ?><i class="flaticon-right-arrow"></i></a>
                                        </div>
                                   </div>
                                   <div class="right">
                                       <div class="blog-comment-num">
                                            <?php comments_popup_link('0', '1', '% '.esc_html__('Comments','socitycore').''); ?>
                                       </div>
                                   </div>
                               </div>
                            </div>
                        </div>
                    </div>
                 <?php endwhile; wp_reset_query(); ?>
                </div>
            </div>
	</div>
	<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_blog_Widget );