<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor progress widget.
 *
 * Elementor widget that displays an escalating progress bar.
 *
 * @since 1.0.0
 */
class socity_about_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve progress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'socity-about';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve progress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'socity About', 'socitycore' );
	}

    
	public function get_categories() {
		return [ 'socitycore' ];
	}
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve progress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-t-letter';
	}
	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'socity', 'about' ];
	}

	/**
	 * Register progress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'socity_about_contens',
			[
				'label' => esc_html__( 'Content', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
            
		$this->add_control(
			'socity_abvout_stitle',
			[
			    'label'   => esc_html__( 'Small Title', 'socitycore' ),
			    'type'    => Controls_Manager::TEXT,
			    'default' => esc_html__('About Us','socitycore'),
			]
		);
		$this->add_control(
			'socity_about_hadding',
			[
				'label' => esc_html__( 'Hadding', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'We have more than about 20+ years experience IT solutions.', 'socitycore' ),
				'placeholder' => esc_html__( 'Type your hadding Content here', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_about_dec',
			[
				'label' => esc_html__( 'Description', 'socitycore' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => wp_kses(
					__( '<p>On the other hand, we denounce with righteous indiation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded desire, that they cannot foresee the pain and trouble that arund to ensue; and equal blame belongs. 
					<ul>
						<li>IT Solutions</li>
						<li>IT Consulting</li>
						<li>IT Services</li>
						<li>IT Insurance</li>
					</ul></p>', 'socitycore' ),
					array(
						'ul'		=>array(),
					    	'li' 		=> array(),
					    	'span' 	=> array(),
					    	'br' 		=> array(),
					    	'strong' 	=> array(),
					)
				),
				'placeholder' => esc_html__( 'Type your Description here', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_about_reb_enable',
			[
			    'label'         => esc_html__( 'Enable Button ', 'socitycore' ),
			    'type'          => Controls_Manager::SWITCHER,
			    'label_on'      => esc_html__( 'On', 'socitycore' ),
			    'label_off'     => esc_html__( 'Off', 'socitycore' ),
			    'return_value'  => 'yes',
			    'default'       => 'no',
			]
		);
		$this->add_control(
			'socity_about_btn_text',
			[
			    'label'   => esc_html__( 'Button Text', 'socitycore' ),
			    'type'    => Controls_Manager::TEXT,
			    'default' => esc_html__('More About','socitycore'),
			    'condition' => [
					'socity_about_reb_enable' => 'yes',
				]
			]
		);
		$this->add_control(
			'socity_about_links',
			[
				'label' => esc_html__( 'Select Link', 'socitycore' ),
				'type'  => Controls_Manager::SELECT,
				'default'	=> 'extranal',
				'options' => [
					'no' => esc_html__( 'Select Options', 'socitycore' ),
					'extranal' => esc_html__( 'Extranal', 'socitycore' ),
					'page' =>  esc_html__( 'Page', 'socitycore' ),
				],
				'condition' => [
                        	'socity_about_reb_enable' => 'yes',
                  	]
			]
		);
		$this->add_control(
			'socity_about_extranal',
			[
				'label' => esc_html__( 'Extranal Link', 'socitycore' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => array(
					'socity_about_links' => 'extranal',
					'socity_about_reb_enable' => 'yes',
				),
				'placeholder' => esc_html__( 'Add Extranal Link', 'socitycore' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'socity_about_page_link',
			[
				'label' => esc_html__( 'Page Link', 'socitycore' ),
				'type' => Controls_Manager::SELECT,
				'options' => socity_page_list(),
				'condition' => array(
					'socity_about_links' => 'page',
					'socity_about_reb_enable' => 'yes',
				),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'socity_about_styles',
			[
				'label' => esc_html__( 'Style', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_about_stitle',
			    'label' => esc_html__( 'Small Title Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .about-titles h4',
			]
		);
		$this->add_control(
			'socity_about_stitle_color',
			[
			    'label' => esc_html__( 'Small Title Color', 'socitycore' ),
			    'type' => Controls_Manager::COLOR,
			    'default'=>'#0a5be0',
			    'selectors' => [
				  '{{WRAPPER}} .about-titles h4' => 'color: {{VALUE}}',
			    ],
			]
		  );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_about_hadding',
			    'label' => esc_html__( 'Hadding Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .about-titles h2',
			]
		);
		$this->add_control(
			'socity_about_hadding_color',
			[
			    'label' => esc_html__( 'Hadding Color', 'socitycore' ),
			    'type' => Controls_Manager::COLOR,
			    'default'=>'#000000',
			    'selectors' => [
				  '{{WRAPPER}} .about-titles h2' => 'color: {{VALUE}}',
			    ],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_about_dec',
			    'label' => esc_html__( 'Description Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .about-content p',
			]
		);
		$this->add_responsive_control(
			'socity_about_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .about-boxs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		  );        
		  $this->add_responsive_control(
			'socity_about_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .about-boxs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		  );   
		  
		$this->end_controls_section();
		$this->start_controls_section(
			'socity_about_btn',
			[
				'label' => esc_html__( 'Button', 'socitycore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('socity_about_btn_tabs');
		$this->start_controls_tab(
			'socity_about_btn_tab',
			[
			    'label' => __( 'Normal', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_about_btn_color',
			[
			    'label' => esc_html__( 'Button Color', 'socitycore' ),
			    'type' => Controls_Manager::COLOR,
			    'selectors' => [
				  '{{WRAPPER}} .about-boxs a.theme-button' => 'color: {{VALUE}}',
			    ],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
			    'name' => 'socity_about_btn_bgcolor',
			    'label' => esc_html__( 'Button Background', 'socitycore' ),
			    'types' => [ 'classic', 'gradient' ],
			    'selector' => '{{WRAPPER}} .about-boxs .colorbg',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'socity_about_btn_htab',
			[
			    'label' => __( 'Hover', 'socitycore' ),
			]
		);
		$this->add_control(
			'socity_about_btn_hcolor',
			[
			    'label' => esc_html__( 'Button Hover Color', 'socitycore' ),
			    'type' => Controls_Manager::COLOR,
			    'default'=>'#ffffff',
			    'selectors' => [
				  '{{WRAPPER}} .about-boxs a.theme-button:hover' => 'color: {{VALUE}}',
			    ],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
			    'name' => 'socity_about_btnh_bgcolor',
			    'label' => esc_html__( 'Button Hover Background', 'socitycore' ),
			    'types' => [ 'classic', 'gradient' ],
			    'selector' => '{{WRAPPER}} .about-boxs a.theme-button:hover',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
			    'name' => 'socity_about_btn_ty',
			    'label' => esc_html__( 'Button Typography', 'socitycore' ),
			    'selector' => '{{WRAPPER}} .about-boxs a.theme-button',
			]
		);
		$this->add_responsive_control(
			'socity_about_btn_margin',
			[
			    'label' => esc_html__( 'Margin', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .about-box .theme-buttons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		  );        
		  $this->add_responsive_control(
			'socity_about_btn_padding',
			[
			    'label' => esc_html__( 'Padding', 'socitycore' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', '%', 'em' ],
			    'selectors' => [
				  '{{WRAPPER}} .about-box .theme-buttons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
			    'separator' =>'before',
			]
		  ); 
		$this->end_controls_section();
	
	}

	/**
	 * Render progress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$socity_about_wp_kses = array(
			'a' => array(
			    'href' => array(),
			    'class' => array()
			),
			'br' => array(),
			'em' => array(),
			'strong' => array(),
			'span' => array(),
			'ul' => array(),
			'li' => array(),
			'p'  =>array(),
		);
		$socity_abouts_wp_kses = array(
			'a' => array(
			    'href' => array(),
			    'class' => array()
			),
			'br' => array(),
			'strong' => array(),
		);
		if( $settings['socity_about_reb_enable'] == 'page' ){
			$socity_about_btn = get_page_link( $settings['socity_about_page_link'] );
		}else{
			$socity_about_btn =  $settings['socity_about_extranal'];
		}
		?>
		<div class="about-boxs">
			<div class="about-box">
				<div class="about-titles">
					<h4 class="color1">
					<?php echo esc_html($settings['socity_abvout_stitle']); ?>
					</h4>
					<h2><?php echo wp_kses( $settings['socity_about_hadding'], $socity_abouts_wp_kses ) ?></h2>
				</div>
				<div class="about-content">
				<?php echo wp_kses(wpautop($settings['socity_about_dec']),$socity_about_wp_kses); ?>
				</div>
				<?php if($settings['socity_about_reb_enable'] == 'yes') : ?>
				<div class="theme-buttons">
					<a href="<?php echo esc_url($socity_about_btn); ?>" class="theme-button colorbg">
						<?php echo esc_html($settings['socity_about_btn_text']) ?><i class="flaticon-right-arrow"></i>
					</a>
				</div>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new socity_about_Widget );