<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
final class eduschool_extension {
	const VERSION = '1.0.0';

	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';

	const MINIMUM_PHP_VERSION = '7.0';

	private static $_instance = null;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
	public function __construct() {

		add_action( 'init', [ $this, 'i18n' ] );
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}
	public function i18n() {
		load_plugin_textdomain( 'socitycore' );
	}
	public function init() {
		require_once( __DIR__ . '/control/check-notice.php' );
		require_once( __DIR__ . '/control/css-load.php' );
	}
	public function admin_notice_missing_main_plugin() {
		require_once( __DIR__ . '/control/messing-notice.php' );
	}
	public function admin_notice_minimum_elementor_version() {
		require_once( __DIR__ . '/control/mimv-notice.php' );
	}
	public function admin_notice_minimum_php_version() {
		require_once( __DIR__ . '/control/mimvp-notice.php' );
	}
	public function init_widgets() {
		// Include Widget files
		require_once( __DIR__ . '/widgets/socity-clients.php' );
		require_once( __DIR__ . '/widgets/socity-about.php' );
		require_once( __DIR__ . '/widgets/socity-about-video.php' );
		require_once( __DIR__ . '/widgets/socity-title.php' );
		require_once( __DIR__ . '/widgets/socity-service.php' );
		require_once( __DIR__ . '/widgets/socity-progress.php' );
		require_once( __DIR__ . '/widgets/socity-pricing.php' );
		require_once( __DIR__ . '/widgets/socity-contact-box.php' );
		require_once( __DIR__ . '/widgets/socity-project.php' );
		require_once( __DIR__ . '/widgets/socity-buttons.php' );
		require_once( __DIR__ . '/widgets/socity-team.php' );
		require_once( __DIR__ . '/widgets/socity-testimonial.php' );
		require_once( __DIR__ . '/widgets/socity-blog.php' );
		require_once( __DIR__ . '/widgets/socity-contact-message.php' );
		require_once( __DIR__ . '/widgets/socity-counter.php' );
		require_once( __DIR__ . '/widgets/socity-support.php' );
		require_once( __DIR__ . '/widgets/socity-promo-content.php' );
		require_once( __DIR__ . '/widgets/socity-contact-info.php' );
		require_once( __DIR__ . '/widgets/socity-slider.php' );
		// Register widget

	}
	public function widget_styles() {
		require_once( __DIR__ . '/control/socity-widget-style.php' );
	}
}
eduschool_extension::instance();